/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.core.foundation.crypto;

import cn.herodotus.stirrup.core.definition.crypto.SymmetricCryptoProcessor;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ByteUtil;
import org.dromara.hutool.core.util.RandomUtil;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.symmetric.AES;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESCryptoProcessor
implements SymmetricCryptoProcessor {
    private static final Logger log = LoggerFactory.getLogger(AESCryptoProcessor.class);

    public String createKey() {
        return RandomUtil.randomStringUpper((int)16);
    }

    public String decrypt(String data, String key) {
        AES aes = SecureUtil.aes((byte[])ByteUtil.toUtf8Bytes((CharSequence)key));
        byte[] result = aes.decrypt(Base64.decode((byte[])ByteUtil.toUtf8Bytes((CharSequence)data)));
        log.trace("[Herodotus] |- AES crypto decrypt data, value is : [{}]", (Object)result);
        return StrUtil.utf8Str((Object)result);
    }

    public String encrypt(String data, String key) {
        AES aes = SecureUtil.aes((byte[])ByteUtil.toUtf8Bytes((CharSequence)key));
        byte[] result = aes.encrypt(ByteUtil.toUtf8Bytes((CharSequence)data));
        log.trace("[Herodotus] |- AES crypto encrypt data, value is : [{}]", (Object)result);
        return StrUtil.utf8Str((Object)result);
    }
}

