/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.core.foundation.json.jackson2.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Jackson2Utils {
    private static final Logger logger = LoggerFactory.getLogger(Jackson2Utils.class);
    private static ObjectMapper OBJECT_MAPPER;
    @Autowired
    private ObjectMapper objectMapper;

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    public static ObjectMapper registerModule(Module module) {
        return Jackson2Utils.getObjectMapper().registerModules(new Module[]{module});
    }

    public static <T> String toJson(T domain) {
        try {
            return Jackson2Utils.getObjectMapper().writeValueAsString(domain);
        }
        catch (JsonProcessingException e) {
            logger.error("[Herodotus] |- Jackson2 json processing error, when to json! {}", (Object)e.getMessage());
            return null;
        }
    }

    public static TypeFactory getTypeFactory() {
        return Jackson2Utils.getObjectMapper().getTypeFactory();
    }

    public static <T> T toObject(String content, Class<T> valueType) {
        try {
            return (T)Jackson2Utils.getObjectMapper().readValue(content, valueType);
        }
        catch (JsonProcessingException e) {
            logger.error("[Herodotus] |- Jackson2 json processing error, when to object with value type! {}", (Object)e.getMessage());
            return null;
        }
    }

    public static <T> T toObject(Map<String, Object> content, Class<T> valueType) {
        try {
            return (T)Jackson2Utils.getObjectMapper().convertValue(content, valueType);
        }
        catch (IllegalArgumentException e) {
            logger.error("[Herodotus] |- Jackson2 json processing error, when to object with value type! {}", (Object)e.getMessage());
            return null;
        }
    }

    public static <T> T toObject(String content, TypeReference<T> typeReference) {
        try {
            return (T)Jackson2Utils.getObjectMapper().readValue(content, typeReference);
        }
        catch (JsonProcessingException e) {
            logger.error("[Herodotus] |- Jackson2 json processing error, when to object with type reference! {}", (Object)e.getMessage());
            return null;
        }
    }

    public static <T> T toObject(String content, JavaType javaType) {
        try {
            return (T)Jackson2Utils.getObjectMapper().readValue(content, javaType);
        }
        catch (JsonProcessingException e) {
            logger.error("[Herodotus] |- Jackson2 json processing error, when to object with java type! {}", (Object)e.getMessage());
            return null;
        }
    }

    public static <T> List<T> toList(String content, Class<T> clazz) {
        JavaType javaType = Jackson2Utils.getObjectMapper().getTypeFactory().constructParametricType(List.class, new Class[]{clazz});
        return (List)Jackson2Utils.toObject(content, javaType);
    }

    public static <K, V> Map<K, V> toMap(String content, Class<K> keyClass, Class<V> valueClass) {
        MapType javaType = Jackson2Utils.getObjectMapper().getTypeFactory().constructMapType(Map.class, keyClass, valueClass);
        return (Map)Jackson2Utils.toObject(content, (JavaType)javaType);
    }

    public static Map<String, Object> toMap(String content) {
        return Jackson2Utils.toMap(content, String.class, Object.class);
    }

    public static <T> Set<T> toSet(String content, Class<T> clazz) {
        CollectionLikeType javaType = Jackson2Utils.getTypeFactory().constructCollectionLikeType(Set.class, clazz);
        return (Set)Jackson2Utils.toObject(content, (JavaType)javaType);
    }

    public static <T> T[] toArray(String content, Class<T> clazz) {
        ArrayType javaType = Jackson2Utils.getTypeFactory().constructArrayType(clazz);
        return (Object[])Jackson2Utils.toObject(content, (JavaType)javaType);
    }

    public static <T> T[] toArray(String content) {
        return Jackson2Utils.toObject(content, new TypeReference<T[]>(){});
    }

    public static JsonNode toNode(String content) {
        try {
            return Jackson2Utils.getObjectMapper().readTree(content);
        }
        catch (JsonProcessingException e) {
            logger.error("[Herodotus] |- Jackson2 json processing error, when to node with string! {}", (Object)e.getMessage());
            return null;
        }
    }

    public static JsonNode toNode(JsonParser jsonParser) {
        try {
            return (JsonNode)Jackson2Utils.getObjectMapper().readTree(jsonParser);
        }
        catch (IOException e) {
            logger.error("[Herodotus] |- Jackson2 io error, when to node with json parser! {}", (Object)e.getMessage());
            return null;
        }
    }

    public static JsonParser createParser(String content) {
        try {
            return Jackson2Utils.getObjectMapper().createParser(content);
        }
        catch (IOException e) {
            logger.error("[Herodotus] |- Jackson2 io error, when create parser! {}", (Object)e.getMessage());
            return null;
        }
    }

    public static <R> R loop(JsonNode jsonNode, Function<JsonNode, R> function) {
        if (jsonNode.isObject()) {
            Iterator it = jsonNode.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                Jackson2Utils.loop((JsonNode)entry.getValue(), function);
            }
        }
        if (jsonNode.isArray()) {
            for (JsonNode node : jsonNode) {
                Jackson2Utils.loop(node, function);
            }
        }
        if (jsonNode.isValueNode()) {
            return function.apply(jsonNode);
        }
        return null;
    }

    @PostConstruct
    public void init() {
        OBJECT_MAPPER = ObjectUtils.isNotEmpty((Object)this.objectMapper) ? this.objectMapper : new ObjectMapper();
    }
}

