/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.core.foundation.utils;

import cn.herodotus.stirrup.core.foundation.enums.Protocol;
import cn.herodotus.stirrup.core.foundation.exception.properties.PropertyValueIsNotSetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;

public class WellFormedUtils {
    public static final ParameterizedTypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new ParameterizedTypeReference<Map<String, Object>>(){};
    private static final Logger log = LoggerFactory.getLogger(WellFormedUtils.class);

    public static String url(String url) {
        if (StringUtils.endsWith((CharSequence)url, (CharSequence)"/")) {
            return url;
        }
        return url + "/";
    }

    public static String parentId(String parentId) {
        if (StringUtils.isBlank((CharSequence)parentId)) {
            return "0";
        }
        return parentId;
    }

    public static String addressToUri(String address, Protocol protocol, boolean endWithForwardSlash) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!StringUtils.startsWith((CharSequence)address, (CharSequence)protocol.getFormat())) {
            stringBuilder.append(protocol.getFormat());
        }
        if (endWithForwardSlash) {
            stringBuilder.append(WellFormedUtils.url(address));
        } else {
            stringBuilder.append(address);
        }
        return stringBuilder.toString();
    }

    public static String addressToUri(String address, boolean endWithForwardSlash) {
        return WellFormedUtils.addressToUri(address, Protocol.HTTP, endWithForwardSlash);
    }

    public static String addressToUri(String address) {
        return WellFormedUtils.addressToUri(address, false);
    }

    public static String getHostAddress() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            return address.getHostAddress();
        }
        catch (UnknownHostException e) {
            log.error("[Herodotus] |- Get host address error: {}", (Object)e.getLocalizedMessage());
            return null;
        }
    }

    public static String serviceUri(String serviceUri, String serviceName, String gatewayServiceUri, String abbreviation) {
        if (StringUtils.isNotBlank((CharSequence)serviceUri)) {
            return serviceUri;
        }
        if (StringUtils.isBlank((CharSequence)serviceName)) {
            log.error("[Herodotus] |- Property [{} Service Name] is not set or property format is incorrect!", (Object)abbreviation);
            throw new PropertyValueIsNotSetException();
        }
        if (StringUtils.isBlank((CharSequence)gatewayServiceUri)) {
            log.error("[Herodotus] |- Property [gateway-service-uri] is not set or property format is incorrect!");
            throw new PropertyValueIsNotSetException();
        }
        return WellFormedUtils.url(gatewayServiceUri) + serviceName;
    }

    public static String sasUri(String uri, String endpoint, String issuerUri) {
        if (StringUtils.isNotBlank((CharSequence)uri)) {
            return uri;
        }
        if (StringUtils.isBlank((CharSequence)issuerUri)) {
            log.error("[Herodotus] |- Property [issuer-uri] is not set or property format is incorrect!");
            throw new PropertyValueIsNotSetException();
        }
        return issuerUri + endpoint;
    }
}

