/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.core.foundation.json.jackson2.deserializer;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.StringUtils;

public class SetToCommaDelimitedStringDeserializer
extends StdDeserializer<String> {
    protected SetToCommaDelimitedStringDeserializer() {
        super(String.class);
    }

    public JavaType getValueType() {
        return TypeFactory.defaultInstance().constructType(Set.class);
    }

    public String deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
        Set collection = (Set)jsonParser.readValueAs((TypeReference)new TypeReference<Set<String>>(this){});
        if (CollectionUtils.isNotEmpty((Collection)collection)) {
            return StringUtils.collectionToCommaDelimitedString((Collection)collection);
        }
        return null;
    }
}

