/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.core.foundation.processor.captcha;

import cn.herodotus.stirrup.core.definition.domain.captcha.Captcha;
import cn.herodotus.stirrup.core.definition.domain.captcha.Verification;
import cn.herodotus.stirrup.core.definition.processor.CaptchaRenderer;
import cn.herodotus.stirrup.core.foundation.enums.CaptchaCategory;
import cn.herodotus.stirrup.core.foundation.exception.captcha.CaptchaCategoryIsIncorrectException;
import cn.herodotus.stirrup.core.foundation.exception.captcha.CaptchaHandlerNotExistException;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * <p>Description: Captcha 工厂 </p>
 *
 * @author : gengwei.zheng
 * @date : 2021/12/14 14:38
 */
@Component
public class CaptchaRendererFactory {

    @Autowired
    private final Map<String, CaptchaRenderer> handlers = new ConcurrentHashMap<>(8);

    public CaptchaRenderer getCaptchaRenderer(String category) {
        CaptchaCategory captchaCategory = CaptchaCategory.getCaptchaCategory(category);

        if (ObjectUtils.isEmpty(captchaCategory)) {
            throw new CaptchaCategoryIsIncorrectException("Captcha category is incorrect.");
        }

        CaptchaRenderer captchaRenderer = handlers.get(captchaCategory.getConstant());
        if (ObjectUtils.isEmpty(captchaRenderer)) {
            throw new CaptchaHandlerNotExistException();
        }

        return captchaRenderer;
    }

    public Captcha getCaptcha(String identity, String category) {
        CaptchaRenderer captchaRenderer = getCaptchaRenderer(category);
        return captchaRenderer.getCaptcha(identity);
    }

    public boolean verify(Verification verification) {
        CaptchaRenderer captchaRenderer = getCaptchaRenderer(verification.getCategory());
        return captchaRenderer.verify(verification);
    }
}
