/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.core.foundation.context;

import cn.herodotus.stirrup.core.foundation.enums.Architecture;
import cn.herodotus.stirrup.core.foundation.enums.Protocol;
import cn.herodotus.stirrup.core.foundation.enums.Target;
import cn.herodotus.stirrup.core.foundation.utils.WellFormedUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class ServiceContextHolder {
    private static volatile ServiceContextHolder instance;
    private Architecture architecture = Architecture.DISTRIBUTED;
    private Target dataAccessStrategy = Target.REMOTE;
    private Protocol protocol = Protocol.HTTP;
    private String port;
    private String ip;
    private String address;
    private String url;
    private String applicationName;
    private ApplicationContext applicationContext;
    private String uaaServiceName;
    private String upmsServiceName;
    private String messageServiceName;
    private String ossServiceName;
    private String gatewayServiceUri;
    private String uaaServiceUri;
    private String upmsServiceUri;
    private String messageServiceUri;
    private String ossServiceUri;
    private String authorizationUri;
    private String authorizationEndpoint = "/oauth2/authorize";
    private String accessTokenUri;
    private String accessTokenEndpoint = "/oauth2/token";
    private String jwkSetUri;
    private String jwkSetEndpoint = "/oauth2/jwks";
    private String tokenRevocationUri;
    private String tokenRevocationEndpoint = "/oauth2/revoke";
    private String tokenIntrospectionUri;
    private String tokenIntrospectionEndpoint = "/oauth2/introspect";
    private String deviceAuthorizationUri;
    private String deviceAuthorizationEndpoint = "/oauth2/device_authorization";
    private String deviceVerificationUri;
    private String deviceVerificationEndpoint = "/oauth2/device_verification";
    private String oidcClientRegistrationUri;
    private String oidcClientRegistrationEndpoint = "/connect/register";
    private String oidcLogoutUri;
    private String oidcLogoutEndpoint = "/connect/logout";
    private String oidcUserInfoUri;
    private String oidcUserInfoEndpoint = "/userinfo";
    private String issuerUri;

    private ServiceContextHolder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceContextHolder getInstance() {
        if (!ObjectUtils.isEmpty((Object)instance)) return instance;
        Class<ServiceContextHolder> clazz = ServiceContextHolder.class;
        synchronized (ServiceContextHolder.class) {
            if (!ObjectUtils.isEmpty((Object)instance)) return instance;
            instance = new ServiceContextHolder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(Architecture architecture) {
        this.architecture = architecture;
    }

    public Target getDataAccessStrategy() {
        return this.dataAccessStrategy;
    }

    public void setDataAccessStrategy(Target dataAccessStrategy) {
        this.dataAccessStrategy = dataAccessStrategy;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getAddress() {
        if (this.isDistributedArchitecture()) {
            this.address = this.getGatewayServiceUri() + "/" + this.getApplicationName();
        } else if (StringUtils.isNotBlank((CharSequence)this.ip) && StringUtils.isNotBlank((CharSequence)this.port)) {
            this.address = this.ip + ":" + this.port;
        }
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getUrl() {
        String address;
        if (StringUtils.isBlank((CharSequence)this.url) && StringUtils.isNotBlank((CharSequence)(address = this.getAddress()))) {
            return WellFormedUtils.addressToUri(address, this.getProtocol(), false);
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String getUaaServiceName() {
        return this.uaaServiceName;
    }

    public void setUaaServiceName(String uaaServiceName) {
        this.uaaServiceName = uaaServiceName;
    }

    public String getUpmsServiceName() {
        return this.upmsServiceName;
    }

    public void setUpmsServiceName(String upmsServiceName) {
        this.upmsServiceName = upmsServiceName;
    }

    public String getMessageServiceName() {
        return this.messageServiceName;
    }

    public void setMessageServiceName(String messageServiceName) {
        this.messageServiceName = messageServiceName;
    }

    public String getOssServiceName() {
        return this.ossServiceName;
    }

    public void setOssServiceName(String ossServiceName) {
        this.ossServiceName = ossServiceName;
    }

    public String getGatewayServiceUri() {
        return this.gatewayServiceUri;
    }

    public void setGatewayServiceUri(String gatewayServiceUri) {
        this.gatewayServiceUri = gatewayServiceUri;
    }

    public String getUaaServiceUri() {
        return this.uaaServiceUri;
    }

    public void setUaaServiceUri(String uaaServiceUri) {
        this.uaaServiceUri = uaaServiceUri;
    }

    public String getUpmsServiceUri() {
        return this.upmsServiceUri;
    }

    public void setUpmsServiceUri(String upmsServiceUri) {
        this.upmsServiceUri = upmsServiceUri;
    }

    public String getMessageServiceUri() {
        return this.messageServiceUri;
    }

    public void setMessageServiceUri(String messageServiceUri) {
        this.messageServiceUri = messageServiceUri;
    }

    public String getOssServiceUri() {
        return this.ossServiceUri;
    }

    public void setOssServiceUri(String ossServiceUri) {
        this.ossServiceUri = ossServiceUri;
    }

    public String getAuthorizationUri() {
        return this.authorizationUri;
    }

    public void setAuthorizationUri(String authorizationUri) {
        this.authorizationUri = authorizationUri;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public String getAccessTokenUri() {
        return this.accessTokenUri;
    }

    public void setAccessTokenUri(String accessTokenUri) {
        this.accessTokenUri = accessTokenUri;
    }

    public String getAccessTokenEndpoint() {
        return this.accessTokenEndpoint;
    }

    public void setAccessTokenEndpoint(String accessTokenEndpoint) {
        this.accessTokenEndpoint = accessTokenEndpoint;
    }

    public String getJwkSetUri() {
        return this.jwkSetUri;
    }

    public void setJwkSetUri(String jwkSetUri) {
        this.jwkSetUri = jwkSetUri;
    }

    public String getJwkSetEndpoint() {
        return this.jwkSetEndpoint;
    }

    public void setJwkSetEndpoint(String jwkSetEndpoint) {
        this.jwkSetEndpoint = jwkSetEndpoint;
    }

    public String getTokenRevocationUri() {
        return this.tokenRevocationUri;
    }

    public void setTokenRevocationUri(String tokenRevocationUri) {
        this.tokenRevocationUri = tokenRevocationUri;
    }

    public String getTokenRevocationEndpoint() {
        return this.tokenRevocationEndpoint;
    }

    public void setTokenRevocationEndpoint(String tokenRevocationEndpoint) {
        this.tokenRevocationEndpoint = tokenRevocationEndpoint;
    }

    public String getTokenIntrospectionUri() {
        return this.tokenIntrospectionUri;
    }

    public void setTokenIntrospectionUri(String tokenIntrospectionUri) {
        this.tokenIntrospectionUri = tokenIntrospectionUri;
    }

    public String getTokenIntrospectionEndpoint() {
        return this.tokenIntrospectionEndpoint;
    }

    public void setTokenIntrospectionEndpoint(String tokenIntrospectionEndpoint) {
        this.tokenIntrospectionEndpoint = tokenIntrospectionEndpoint;
    }

    public String getDeviceAuthorizationUri() {
        return this.deviceAuthorizationUri;
    }

    public void setDeviceAuthorizationUri(String deviceAuthorizationUri) {
        this.deviceAuthorizationUri = deviceAuthorizationUri;
    }

    public String getDeviceAuthorizationEndpoint() {
        return this.deviceAuthorizationEndpoint;
    }

    public void setDeviceAuthorizationEndpoint(String deviceAuthorizationEndpoint) {
        this.deviceAuthorizationEndpoint = deviceAuthorizationEndpoint;
    }

    public String getDeviceVerificationUri() {
        return this.deviceVerificationUri;
    }

    public void setDeviceVerificationUri(String deviceVerificationUri) {
        this.deviceVerificationUri = deviceVerificationUri;
    }

    public String getDeviceVerificationEndpoint() {
        return this.deviceVerificationEndpoint;
    }

    public void setDeviceVerificationEndpoint(String deviceVerificationEndpoint) {
        this.deviceVerificationEndpoint = deviceVerificationEndpoint;
    }

    public String getOidcClientRegistrationUri() {
        return this.oidcClientRegistrationUri;
    }

    public void setOidcClientRegistrationUri(String oidcClientRegistrationUri) {
        this.oidcClientRegistrationUri = oidcClientRegistrationUri;
    }

    public String getOidcClientRegistrationEndpoint() {
        return this.oidcClientRegistrationEndpoint;
    }

    public void setOidcClientRegistrationEndpoint(String oidcClientRegistrationEndpoint) {
        this.oidcClientRegistrationEndpoint = oidcClientRegistrationEndpoint;
    }

    public String getOidcLogoutUri() {
        return this.oidcLogoutUri;
    }

    public void setOidcLogoutUri(String oidcLogoutUri) {
        this.oidcLogoutUri = oidcLogoutUri;
    }

    public String getOidcLogoutEndpoint() {
        return this.oidcLogoutEndpoint;
    }

    public void setOidcLogoutEndpoint(String oidcLogoutEndpoint) {
        this.oidcLogoutEndpoint = oidcLogoutEndpoint;
    }

    public String getOidcUserInfoUri() {
        return this.oidcUserInfoUri;
    }

    public void setOidcUserInfoUri(String oidcUserInfoUri) {
        this.oidcUserInfoUri = oidcUserInfoUri;
    }

    public String getOidcUserInfoEndpoint() {
        return this.oidcUserInfoEndpoint;
    }

    public void setOidcUserInfoEndpoint(String oidcUserInfoEndpoint) {
        this.oidcUserInfoEndpoint = oidcUserInfoEndpoint;
    }

    public String getIssuerUri() {
        return this.issuerUri;
    }

    public void setIssuerUri(String issuerUri) {
        this.issuerUri = issuerUri;
    }

    public boolean isDistributedArchitecture() {
        return this.getArchitecture() == Architecture.DISTRIBUTED;
    }

    public String getOriginService() {
        return this.getApplicationName() + ":" + this.getPort();
    }

    public void publishEvent(ApplicationEvent applicationEvent) {
        this.getApplicationContext().publishEvent(applicationEvent);
    }

    public String getId() {
        return this.getApplicationName() + ":" + this.getPort();
    }

    public boolean isFromSelf(String serviceId) {
        if (StringUtils.contains((CharSequence)serviceId, (CharSequence)":")) {
            return StringUtils.equals((CharSequence)serviceId, (CharSequence)this.getId());
        }
        return false;
    }
}

