/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.core.foundation.json.jackson2.deserializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CommaDelimitedStringToSetSerializer
extends StdSerializer<String> {
    public CommaDelimitedStringToSetSerializer() {
        super(String.class);
    }

    public void serialize(String value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        HashSet<String> collection = new HashSet<String>();
        if (org.springframework.util.StringUtils.hasText((String)value)) {
            if (StringUtils.contains((CharSequence)value, (CharSequence)",")) {
                collection = org.springframework.util.StringUtils.commaDelimitedListToSet((String)value);
            } else {
                collection.add(value);
            }
        }
        int len = collection.size();
        gen.writeStartArray(collection, len);
        this.serializeContents(collection, gen, provider);
        gen.writeEndArray();
    }

    private void serializeContents(Set<String> value, JsonGenerator g, SerializerProvider provider) throws IOException {
        int i = 0;
        try {
            for (String str : value) {
                if (str == null) {
                    provider.defaultSerializeNull(g);
                } else {
                    g.writeString(str);
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(provider, e, value, i);
        }
    }
}

