/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.core.foundation.processor.captcha;

import cn.herodotus.stirrup.core.definition.domain.captcha.Captcha;
import cn.herodotus.stirrup.core.definition.domain.captcha.Verification;
import cn.herodotus.stirrup.core.definition.processor.CaptchaRenderer;
import cn.herodotus.stirrup.core.foundation.enums.CaptchaCategory;
import cn.herodotus.stirrup.core.foundation.exception.captcha.CaptchaCategoryIsIncorrectException;
import cn.herodotus.stirrup.core.foundation.exception.captcha.CaptchaHandlerNotExistException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CaptchaRendererFactory {
    @Autowired
    private final Map<String, CaptchaRenderer> handlers = new ConcurrentHashMap<String, CaptchaRenderer>(8);

    public CaptchaRenderer getCaptchaRenderer(String category) {
        CaptchaCategory captchaCategory = CaptchaCategory.getCaptchaCategory(category);
        if (ObjectUtils.isEmpty((Object)((Object)captchaCategory))) {
            throw new CaptchaCategoryIsIncorrectException("Captcha category is incorrect.");
        }
        CaptchaRenderer captchaRenderer = this.handlers.get(captchaCategory.getConstant());
        if (ObjectUtils.isEmpty((Object)captchaRenderer)) {
            throw new CaptchaHandlerNotExistException();
        }
        return captchaRenderer;
    }

    public Captcha getCaptcha(String identity, String category) {
        CaptchaRenderer captchaRenderer = this.getCaptchaRenderer(category);
        return captchaRenderer.getCaptcha(identity);
    }

    public boolean verify(Verification verification) {
        CaptchaRenderer captchaRenderer = this.getCaptchaRenderer(verification.getCategory());
        return captchaRenderer.verify(verification);
    }
}

