/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.core.foundation.utils.protect;

import cn.herodotus.stirrup.core.foundation.json.gson.GsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.dromara.hutool.core.net.url.UrlDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlInjectionUtils {
    private static final Logger log = LoggerFactory.getLogger(SqlInjectionUtils.class);
    private static final String SQL_REGEX = "\\b(and|or)\\b.{1,6}?(=|>|<|\\bin\\b|\\blike\\b)|\\/\\*.+?\\*\\/|<\\s*script\\b|\\bEXEC\\b|UNION.+?SELECT|UPDATE.+?SET|INSERT\\s+INTO.+?VALUES|(SELECT|DELETE).+?FROM|(CREATE|ALTER|DROP|TRUNCATE)\\s+(TABLE|DATABASE)";
    private static final Pattern SQL_PATTERN = Pattern.compile("\\b(and|or)\\b.{1,6}?(=|>|<|\\bin\\b|\\blike\\b)|\\/\\*.+?\\*\\/|<\\s*script\\b|\\bEXEC\\b|UNION.+?SELECT|UPDATE.+?SET|INSERT\\s+INTO.+?VALUES|(SELECT|DELETE).+?FROM|(CREATE|ALTER|DROP|TRUNCATE)\\s+(TABLE|DATABASE)", 2);

    private static boolean matching(String lowerValue, String param) {
        if (SQL_PATTERN.matcher(param).find()) {
            log.error("[Herodotus] |- The parameter contains keywords {} that do not allow SQL!", (Object)lowerValue);
            return true;
        }
        return false;
    }

    private static String toLowerCase(Object obj) {
        return Optional.ofNullable(obj).map(Object::toString).map(String::toLowerCase).orElse(null);
    }

    private static boolean checking(Object value) {
        String lowerValue = SqlInjectionUtils.toLowerCase(value);
        return Optional.ofNullable(lowerValue).map(data -> SqlInjectionUtils.matching(data, data)).orElse(false);
    }

    public static boolean checkForGet(String value) {
        String lowerValue = UrlDecoder.decode((String)value, (Charset)StandardCharsets.UTF_8).toLowerCase();
        return ((Stream)Stream.of(lowerValue.split("\\&")).map(kp -> kp.substring(kp.indexOf("=") + 1)).parallel()).anyMatch(param -> SqlInjectionUtils.matching(lowerValue, param));
    }

    public static boolean checkForPost(String value) {
        ArrayList<JsonElement> result = new ArrayList<JsonElement>();
        JsonElement jsonElement = GsonUtils.toJsonElement(value);
        SqlInjectionUtils.iterator(jsonElement, result);
        return CollectionUtils.isNotEmpty(result);
    }

    private static void iterator(JsonElement jsonElement, List<JsonElement> result) {
        if (jsonElement.isJsonNull()) {
            return;
        }
        if (jsonElement.isJsonPrimitive()) {
            boolean hasInjection = SqlInjectionUtils.checking(jsonElement.toString());
            if (hasInjection) {
                result.add(jsonElement);
            }
            return;
        }
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            if (ObjectUtils.isNotEmpty((Object)jsonArray)) {
                for (JsonElement je : jsonArray) {
                    SqlInjectionUtils.iterator(je, result);
                }
            }
            return;
        }
        if (jsonElement.isJsonObject()) {
            Set es = jsonElement.getAsJsonObject().entrySet();
            for (Map.Entry en : es) {
                SqlInjectionUtils.iterator((JsonElement)en.getValue(), result);
            }
        }
    }
}

