/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.core.identity.handler;

import cn.herodotus.stirrup.core.identity.domain.AccessPrincipal;
import cn.herodotus.stirrup.core.identity.domain.HerodotusUser;
import cn.herodotus.stirrup.core.identity.domain.SocialUserDetails;
import cn.herodotus.stirrup.core.identity.exception.AccessIdentityVerificationFailedException;
import cn.herodotus.stirrup.core.identity.exception.SocialCredentialsUserBindingFailedException;
import cn.herodotus.stirrup.core.identity.exception.UsernameAlreadyExistsException;
import cn.herodotus.stirrup.core.identity.handler.SocialAuthenticationHandler;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.security.core.AuthenticationException;

public abstract class AbstractSocialAuthenticationHandler
implements SocialAuthenticationHandler {
    public abstract SocialUserDetails identity(String var1, AccessPrincipal var2) throws AccessIdentityVerificationFailedException;

    public abstract SocialUserDetails isUserExist(SocialUserDetails var1);

    public abstract HerodotusUser register(SocialUserDetails var1) throws UsernameAlreadyExistsException;

    public abstract void binding(String var1, SocialUserDetails var2) throws SocialCredentialsUserBindingFailedException;

    public abstract void additionalRegisterOperation(HerodotusUser var1, SocialUserDetails var2);

    public abstract HerodotusUser signIn(SocialUserDetails var1);

    public abstract void additionalSignInOperation(HerodotusUser var1, SocialUserDetails var2, SocialUserDetails var3);

    @Override
    public HerodotusUser authentication(String source, AccessPrincipal accessPrincipal) throws AuthenticationException {
        SocialUserDetails newSocialUserDetails = this.identity(source, accessPrincipal);
        SocialUserDetails oldSocialUserDetails = this.isUserExist(newSocialUserDetails);
        if (ObjectUtils.isEmpty((Object)oldSocialUserDetails)) {
            HerodotusUser HerodotusUser2 = this.register(newSocialUserDetails);
            this.binding(HerodotusUser2.getUserId(), newSocialUserDetails);
            this.additionalRegisterOperation(HerodotusUser2, newSocialUserDetails);
            return HerodotusUser2;
        }
        HerodotusUser HerodotusUser3 = this.signIn(oldSocialUserDetails);
        this.additionalSignInOperation(HerodotusUser3, newSocialUserDetails, oldSocialUserDetails);
        return HerodotusUser3;
    }
}

