/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.web.core.definition;

import cn.herodotus.stirrup.core.definition.domain.Result;
import cn.herodotus.stirrup.core.definition.domain.base.Entity;
import reactor.core.publisher.Mono;

import java.util.List;

/**
 * <p>Description: 响应式 Controller 基础实现 </p>
 *
 * @author : gengwei.zheng
 * @date : 2024/4/25 21:51
 */
public interface ReactiveController extends Controller {

    default <T> Mono<Result<T>> result(Mono<T> result) {
        return result
                .map(data -> Result.success("查询成功", data))
                .switchIfEmpty(Mono.defer(() -> Mono.just(Result.empty())));
    }

    /**
     * 数据列表转换为统一响应实体
     *
     * @param domains 数据实体 List
     * @param <E>     {@link Entity} 子类型
     * @return {@link Result} List
     */
    default <E> Mono<Result<List<E>>> fromList(Mono<List<E>> domains) {
        return domains
                .map(data -> Result.success("查询成功", data))
                .switchIfEmpty(Mono.defer(() -> Mono.just(Result.empty("未查询到数据！"))));
    }
}
