/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.web.core.reactive.definition;

import org.springframework.web.server.ServerWebExchange;

import java.util.function.BiFunction;

/**
 * <p>Description: WebFlux RequestBody 请求体修改器 </p>
 * <p>
 * WebFlux 环境下对请求体内容进行修改操作的统一定义接口。主要用于常规的 POST 类型请求
 *
 * @author : gengwei.zheng
 * @date : 2024/4/20 13:04
 */
public interface RequestBodyModifier extends BiFunction<ServerWebExchange, String, String> {
}
