/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.web.core.reactive.secure;

import cn.herodotus.stirrup.core.foundation.utils.protect.SqlInjectionUtils;
import cn.herodotus.stirrup.web.core.reactive.definition.RequestBodyModifier;
import cn.herodotus.stirrup.web.core.reactive.utils.ExchangeUtils;
import org.springframework.web.server.ServerWebExchange;

/**
 * <p>Description: SQL 注入防护请求体修改器 </p>
 *
 * @author : gengwei.zheng
 * @date : 2024/4/20 13:09
 */
public class SqlInjectionRequestBodyChecker implements RequestBodyModifier {

    @Override
    public String apply(ServerWebExchange exchange, String bodyString) {

        boolean isSQLInjection;
        if (ExchangeUtils.isJson(exchange)) {
            //如果MediaType是json才执行json方式验证
            isSQLInjection = SqlInjectionUtils.checkForPost(bodyString);
        } else {
            //form表单方式，需要走get请求
            isSQLInjection = SqlInjectionUtils.checkForGet(bodyString);
        }

        // isSQLInjection 为 true 则包含违规内容，false 不包含违规内容
        // 这里没有直接返回 true 和 false，主要为了方便 统一定义 RequestBodyModifier，与其他调用方式统一
        // 如果返回 null，那么则认为是存在 SQL 注入的；否则直接将请求体返回，方便后续操作。
        return isSQLInjection ? null : bodyString;
    }
}
