/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.web.core.reactive.utils;

import cn.herodotus.stirrup.web.core.constants.WebConstants;
import cn.herodotus.stirrup.web.core.reactive.utils.CookieUtils;
import cn.herodotus.stirrup.web.core.reactive.utils.HeaderUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

public class SessionUtils {
    public static Mono<WebSession> getSession(ServerWebExchange exchange) {
        return exchange.getSession();
    }

    public static String getSessionIdFromHeader(ServerWebExchange exchange) {
        return CookieUtils.getAnyCookieValueFromHeader(exchange, WebConstants.SESSION_IDS);
    }

    public static Mono<String> analyseSessionId(ServerWebExchange exchange) {
        Mono<WebSession> webSessionMono = SessionUtils.getSession(exchange);
        return webSessionMono.map(WebSession::getId).switchIfEmpty(Mono.defer(() -> Mono.justOrEmpty((Object)SessionUtils.getSessionIdFromHeader(exchange)).switchIfEmpty(Mono.defer(() -> Mono.justOrEmpty((Object)HeaderUtils.getHerodotusTenantId(exchange))))));
    }
}

