/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.web.core.definition;

import cn.herodotus.stirrup.core.definition.domain.Result;
import cn.herodotus.stirrup.core.definition.domain.base.Entity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.dromara.hutool.core.tree.MapTree;
import org.dromara.hutool.core.tree.TreeNode;
import org.dromara.hutool.core.tree.TreeUtil;
import org.springframework.core.convert.converter.Converter;

public interface Controller {
    default public <E extends Entity> Result<E> result(E domain) {
        if (ObjectUtils.isNotEmpty(domain)) {
            return Result.content(domain);
        }
        return Result.empty();
    }

    default public <E extends Entity> Result<List<E>> result(List<E> domains) {
        if (null == domains) {
            return Result.failure((String)"\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff01");
        }
        if (CollectionUtils.isNotEmpty(domains)) {
            return Result.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", domains);
        }
        return Result.empty((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
    }

    default public <T> Result<T[]> result(T[] domains) {
        if (ArrayUtils.isNotEmpty((Object[])domains)) {
            return Result.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", domains);
        }
        return Result.empty((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
    }

    default public Result<Map<String, Object>> result(Map<String, Object> map) {
        if (null == map) {
            return Result.failure((String)"\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff01");
        }
        if (MapUtils.isNotEmpty(map)) {
            return Result.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", map);
        }
        return Result.empty((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
    }

    default public Result<String> result(String parameter) {
        if (ObjectUtils.isNotEmpty((Object)parameter)) {
            return Result.success((String)"\u64cd\u4f5c\u6210\u529f!", (Object)parameter);
        }
        return Result.failure((String)"\u64cd\u4f5c\u5931\u8d25!", (Object)parameter);
    }

    default public Result<Boolean> result(boolean status) {
        if (status) {
            return Result.success((String)"\u64cd\u4f5c\u6210\u529f!", (Object)true);
        }
        return Result.failure((String)"\u64cd\u4f5c\u5931\u8d25!", (Object)false);
    }

    default public <E extends Entity> Result<List<MapTree<String>>> result(List<E> domains, Converter<E, TreeNode<String>> toTreeNode) {
        if (ObjectUtils.isNotEmpty(domains)) {
            List treeNodes = domains.stream().map(arg_0 -> toTreeNode.convert(arg_0)).collect(Collectors.toList());
            return Result.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f", (Object)TreeUtil.build(treeNodes, (Object)"0"));
        }
        return Result.empty((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
    }

    default public <E extends Entity> Map<String, Object> getPageInfoMap(List<E> content, int totalPages, long totalElements) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put("content", content);
        result.put("totalPages", totalPages);
        result.put("totalElements", totalElements);
        return result;
    }
}

