/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.web.core.reactive.utils;

import cn.herodotus.stirrup.web.core.definition.utils.HttpUtils;
import cn.herodotus.stirrup.web.core.reactive.utils.HeaderUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.http.HttpCookie;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;

public class CookieUtils
extends HttpUtils {
    public static MultiValueMap<String, HttpCookie> getCookies(ServerWebExchange exchange) {
        return exchange.getRequest().getCookies();
    }

    public static HttpCookie getCookie(ServerWebExchange exchange, String name) {
        return (HttpCookie)CookieUtils.getCookies(exchange).getFirst((Object)name);
    }

    public static String getCookieValue(ServerWebExchange exchange, String name) {
        HttpCookie cookie = CookieUtils.getCookie(exchange, name);
        return ObjectUtils.isNotEmpty((Object)cookie) ? cookie.getValue() : null;
    }

    public static String getCookieFromHeader(ServerWebExchange exchange) {
        return HeaderUtils.getFirstHeader(exchange, "Cookie");
    }

    public static String getCookieValueFromHeader(ServerWebExchange exchange, String name) {
        String cookie = CookieUtils.getCookieFromHeader(exchange);
        return CookieUtils.get(cookie, name);
    }

    public static String getAnyCookieValueFromHeader(ServerWebExchange exchange, String ... name) {
        String cookie = CookieUtils.getCookieFromHeader(exchange);
        return CookieUtils.getAny(cookie, name);
    }
}

