/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.web.core.reactive.utils;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;

public class HeaderUtils {
    public static HttpHeaders getHeaders(ServerWebExchange exchange) {
        return exchange.getRequest().getHeaders();
    }

    public static List<String> getHeader(ServerWebExchange exchange, String name) {
        HttpHeaders httpHeaders = HeaderUtils.getHeaders(exchange);
        if (MapUtils.isNotEmpty((Map)httpHeaders)) {
            return httpHeaders.get((Object)name);
        }
        return ImmutableList.of();
    }

    public static String getFirstHeader(ServerWebExchange exchange, String name) {
        List<String> header = HeaderUtils.getHeader(exchange, name);
        if (CollectionUtils.isNotEmpty(header)) {
            return header.getFirst();
        }
        return null;
    }

    public static String getHerodotusSessionId(ServerWebExchange exchange) {
        return HeaderUtils.getFirstHeader(exchange, "X-Herodotus-Session-id");
    }

    public static String getHerodotusTenantId(ServerWebExchange exchange) {
        return HeaderUtils.getFirstHeader(exchange, "X-Herodotus-Tenant-Id");
    }

    public static String getHerodotusFromIn(ServerWebExchange exchange) {
        return HeaderUtils.getFirstHeader(exchange, "X-Herodotus-From-In");
    }

    public static String getAuthorization(ServerWebExchange exchange) {
        return HeaderUtils.getFirstHeader(exchange, "Authorization");
    }

    public static String getContentType(ServerWebExchange exchange) {
        return HeaderUtils.getFirstHeader(exchange, "Content-Type");
    }

    public static String getWebsocketProtocol(ServerWebExchange exchange) {
        return HeaderUtils.getFirstHeader(exchange, "Sec-WebSocket-Protocol");
    }

    public static void setHeaders(HttpHeaders headers, String headerName, String headerValue) {
        headers.set(headerName, headerValue);
    }

    public static HttpHeaders resetContentLength(ServerWebExchange exchange, int contentLength) {
        HttpHeaders headers = new HttpHeaders();
        headers.putAll((Map)HeaderUtils.getHeaders(exchange));
        headers.remove((Object)"Content-Length");
        headers.setContentLength((long)contentLength);
        return headers;
    }

    public static void addResponseContentType(ServerHttpResponse response, String contentType) {
        response.getHeaders().add("Content-Type", contentType);
    }
}

