/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.web.core.reactive.utils;

import io.netty.buffer.ByteBufAllocator;
import java.util.concurrent.atomic.AtomicReference;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ByteUtil;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RequestBodyUtils {
    public static DataBuffer toDataBuffer(byte[] bytes) {
        NettyDataBufferFactory nettyDataBufferFactory = new NettyDataBufferFactory(ByteBufAllocator.DEFAULT);
        NettyDataBuffer buffer = nettyDataBufferFactory.allocateBuffer(bytes.length);
        buffer.write(bytes);
        return buffer;
    }

    public static DataBuffer toDataBuffer(String value) {
        byte[] bytes = ByteUtil.toUtf8Bytes((CharSequence)value);
        return RequestBodyUtils.toDataBuffer(bytes);
    }

    public static byte[] toBytes(DataBuffer dataBuffer) {
        byte[] bytes = new byte[dataBuffer.readableByteCount()];
        dataBuffer.read(bytes);
        DataBufferUtils.release((DataBuffer)dataBuffer);
        return bytes;
    }

    public static String toString(DataBuffer dataBuffer) {
        byte[] bytes = RequestBodyUtils.toBytes(dataBuffer);
        return StrUtil.utf8Str((Object)bytes);
    }

    public static Flux<DataBuffer> stringToFlux(String body) {
        return Flux.just((Object)RequestBodyUtils.toDataBuffer(body));
    }

    public static String fluxToString(Flux<DataBuffer> body) {
        AtomicReference atomicReference = new AtomicReference();
        body.subscribe(dataBuffer -> atomicReference.set(RequestBodyUtils.toString(dataBuffer)));
        return (String)atomicReference.get();
    }

    public static Flux<DataBuffer> cached(ServerWebExchange exchange, byte[] bytes) {
        return Flux.defer(() -> {
            DataBuffer buffer = exchange.getResponse().bufferFactory().wrap(bytes);
            DataBufferUtils.retain((DataBuffer)buffer);
            return Mono.just((Object)buffer);
        });
    }

    public static String getBodyString(ServerWebExchange exchange) {
        return RequestBodyUtils.getBodyString(exchange.getRequest());
    }

    public static String getBodyString(ServerHttpRequest request) {
        return RequestBodyUtils.fluxToString((Flux<DataBuffer>)request.getBody());
    }
}

