/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.web.core.reactive.utils;

import cn.herodotus.stirrup.core.definition.domain.Feedback;
import cn.herodotus.stirrup.core.definition.domain.Result;
import cn.herodotus.stirrup.core.foundation.json.jackson2.utils.Jackson2Utils;
import cn.herodotus.stirrup.web.core.reactive.utils.HeaderUtils;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ResponseUtils {
    public static Mono<Void> renderJson(ServerHttpResponse response, Result<String> result) {
        HeaderUtils.addResponseContentType(response, "application/json");
        response.setStatusCode((HttpStatusCode)HttpStatus.valueOf((int)result.getStatus()));
        String jsonResult = Jackson2Utils.toJson(result);
        byte[] bytes = StringUtils.isNotBlank((CharSequence)jsonResult) ? jsonResult.getBytes(StandardCharsets.UTF_8) : new byte[]{};
        DataBuffer buffer = response.bufferFactory().wrap(bytes);
        return response.writeWith((Publisher)Flux.just((Object)buffer));
    }

    public static Mono<Void> renderError(ServerWebExchange exchange, Feedback feedback, int status) {
        Result result = new Result();
        result.type(feedback);
        result.status(status);
        return ResponseUtils.renderJson(exchange.getResponse(), (Result<String>)result);
    }
}

