/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.web.core.servlet.utils;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.server.ServerHttpRequest;

public class HeaderUtils {
    public static List<String> getHeaders(HttpHeaders httpHeaders, String name) {
        return httpHeaders.get((Object)name);
    }

    public static List<String> getHeaders(ServerHttpRequest serverHttpRequest, String name) {
        return HeaderUtils.getHeaders(serverHttpRequest.getHeaders(), name);
    }

    public static String getHeader(HttpHeaders httpHeaders, String name) {
        List<String> values = HeaderUtils.getHeaders(httpHeaders, name);
        return CollectionUtils.isNotEmpty(values) ? values.get(0) : null;
    }

    public static String getHeader(ServerHttpRequest serverHttpRequest, String name) {
        return HeaderUtils.getHeader(serverHttpRequest.getHeaders(), name);
    }

    public static String getHeader(HttpServletRequest httpServletRequest, String name) {
        return httpServletRequest.getHeader(name);
    }

    public static boolean hasHeader(HttpHeaders httpHeaders, String name) {
        return httpHeaders.containsKey((Object)name);
    }

    public static Boolean hasHeader(HttpServletRequest httpServletRequest, String name) {
        return StringUtils.isNotBlank((CharSequence)HeaderUtils.getHeader(httpServletRequest, name));
    }

    public static Boolean hasHeader(ServerHttpRequest serverHttpRequest, String name) {
        return HeaderUtils.hasHeader(serverHttpRequest.getHeaders(), name);
    }

    public static String getHerodotusSessionId(HttpServletRequest httpServletRequest) {
        return HeaderUtils.getHeader(httpServletRequest, "X-Herodotus-Session-id");
    }

    public static String getHerodotusSessionId(ServerHttpRequest serverHttpRequest) {
        return HeaderUtils.getHeader(serverHttpRequest, "X-Herodotus-Session-id");
    }

    public static String getHerodotusSessionId(HttpInputMessage httpInputMessage) {
        return HeaderUtils.getHeader(httpInputMessage.getHeaders(), "X-Herodotus-Session-id");
    }

    public static String getHerodotusTenantId(HttpServletRequest httpServletRequest) {
        return HeaderUtils.getHeader(httpServletRequest, "X-Herodotus-Tenant-Id");
    }

    public static String getHerodotusFromIn(HttpServletRequest httpServletRequest) {
        return HeaderUtils.getHeader(httpServletRequest, "X-Herodotus-From-In");
    }

    public static boolean hasHerodotusSessionIdHeader(HttpServletRequest httpServletRequest) {
        return HeaderUtils.hasHeader(httpServletRequest, "X-Herodotus-Session-id");
    }

    public static boolean hasHerodotusSessionIdHeader(ServerHttpRequest serverHttpRequest) {
        return HeaderUtils.hasHeader(serverHttpRequest, "X-Herodotus-Session-id");
    }

    public static boolean hasHerodotusSessionIdHeader(HttpInputMessage httpInputMessage) {
        return HeaderUtils.hasHeader(httpInputMessage.getHeaders(), "X-Herodotus-Session-id");
    }

    public static String getCookie(HttpServletRequest httpServletRequest) {
        return HeaderUtils.getHeader(httpServletRequest, "Cookie");
    }

    public static String getCookie(ServerHttpRequest serverHttpRequest) {
        return HeaderUtils.getHeader(serverHttpRequest, "Cookie");
    }

    public static String getCookie(HttpInputMessage httpInputMessage) {
        return HeaderUtils.getHeader(httpInputMessage.getHeaders(), "Cookie");
    }

    public static String getAuthorization(HttpServletRequest httpServletRequest) {
        return HeaderUtils.getHeader(httpServletRequest, "Authorization");
    }

    public static String getBearerToken(HttpServletRequest request) {
        String header = HeaderUtils.getAuthorization(request);
        if (StringUtils.isNotBlank((CharSequence)header) && StringUtils.startsWith((CharSequence)header, (CharSequence)"Bearer ")) {
            return StringUtils.remove((String)header, (String)"Bearer ");
        }
        return null;
    }

    public static String getOrigin(HttpServletRequest httpServletRequest) {
        return HeaderUtils.getHeader(httpServletRequest, "Origin");
    }
}

