/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.web.core.servlet.utils;

import cn.herodotus.stirrup.web.core.servlet.utils.CookieUtils;
import cn.herodotus.stirrup.web.core.servlet.utils.HeaderUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.server.ServerHttpRequest;

public class SessionUtils {
    private static final String[] SESSION_IDS = new String[]{"JSESSIONID, SESSION"};

    public static HttpSession getSession(HttpServletRequest httpServletRequest, boolean create) {
        return httpServletRequest.getSession(create);
    }

    public static HttpSession getSession(HttpServletRequest httpServletRequest) {
        return SessionUtils.getSession(httpServletRequest, false);
    }

    public static String getSessionId(HttpServletRequest httpServletRequest, boolean create) {
        HttpSession httpSession = SessionUtils.getSession(httpServletRequest, create);
        return ObjectUtils.isNotEmpty((Object)httpSession) ? httpSession.getId() : null;
    }

    public static String getSessionId(HttpServletRequest httpServletRequest) {
        return SessionUtils.getSessionId(httpServletRequest, false);
    }

    public static String getSessionIdFromHeader(HttpInputMessage httpInputMessage) {
        return CookieUtils.getAnyFromCookieHeader(httpInputMessage, SESSION_IDS);
    }

    public static String getSessionIdFromHeader(ServerHttpRequest serverHttpRequest) {
        return CookieUtils.getAnyFromCookieHeader(serverHttpRequest, SESSION_IDS);
    }

    public static String analyseSessionId(HttpServletRequest httpServletRequest) {
        String sessionId = SessionUtils.getSessionId(httpServletRequest);
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            sessionId = HeaderUtils.getHerodotusSessionId(httpServletRequest);
        }
        return sessionId;
    }

    public static String analyseSessionId(ServerHttpRequest serverHttpRequest) {
        String sessionId = SessionUtils.getSessionIdFromHeader(serverHttpRequest);
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            sessionId = HeaderUtils.getHerodotusSessionId(serverHttpRequest);
        }
        return sessionId;
    }

    public static String analyseSessionId(HttpInputMessage httpInputMessage) {
        String sessionId = SessionUtils.getSessionIdFromHeader(httpInputMessage);
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            sessionId = HeaderUtils.getHerodotusSessionId(httpInputMessage);
        }
        return sessionId;
    }

    public static boolean isCryptoEnabled(HttpServletRequest httpServletRequest, String sessionId) {
        return HeaderUtils.hasHerodotusSessionIdHeader(httpServletRequest) && StringUtils.isNotBlank((CharSequence)sessionId);
    }

    public static boolean isCryptoEnabled(HttpInputMessage httpInputMessage, String sessionId) {
        return HeaderUtils.hasHerodotusSessionIdHeader(httpInputMessage) && StringUtils.isNotBlank((CharSequence)sessionId);
    }
}

