/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.web.core.reactive.secure;

import cn.herodotus.stirrup.core.foundation.utils.protect.XssUtils;
import cn.herodotus.stirrup.web.core.reactive.definition.RequestBodyModifier;
import org.springframework.web.server.ServerWebExchange;

/**
 * <p>Description: XSS 防护请求体修改器 </p>
 *
 * @author : gengwei.zheng
 * @date : 2024/4/20 13:07
 */
public class XssRequestBodyChecker implements RequestBodyModifier {

    @Override
    public String apply(ServerWebExchange exchange, String bodyString) {
        return XssUtils.cleaning(bodyString);
    }
}
