/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.web.core.reactive.utils;

import cn.herodotus.stirrup.core.definition.domain.Feedback;
import cn.herodotus.stirrup.core.definition.domain.Result;
import cn.herodotus.stirrup.core.foundation.json.jackson2.utils.Jackson2Utils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

import java.nio.charset.StandardCharsets;

/**
 * <p>Description: WebFlux 响应工具类 </p>
 *
 * @author : gengwei.zheng
 * @date : 2024/4/21 16:27
 */
public class ResponseUtils {

    public static Mono<Void> renderJson(ServerHttpResponse response, Result<String> result) {
        HeaderUtils.addResponseContentType(response, MediaType.APPLICATION_JSON_VALUE);
        response.setStatusCode(HttpStatus.valueOf(result.getStatus()));

        String jsonResult = Jackson2Utils.toJson(result);
        byte[] bytes = StringUtils.isNotBlank(jsonResult) ? jsonResult.getBytes(StandardCharsets.UTF_8) : new byte[]{};

        DataBuffer buffer = response.bufferFactory().wrap(bytes);
        return response.writeWith(Flux.just(buffer));
    }

    /**
     * 响应中返回统一格式错误信息
     *
     * @param exchange 请求 {@link ServerWebExchange}
     * @param feedback 错误信息 {@link Feedback}
     * @param status   错误状态 {@link HttpStatus}
     * @return Mono<Void>
     */
    public static Mono<Void> renderError(ServerWebExchange exchange, Feedback feedback, int status) {
        Result<String> result = new Result<>();
        result.type(feedback);
        result.status(status);
        return renderJson(exchange.getResponse(), result);
    }
}
