/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.web.core.definition.utils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpMethod;

public class HttpUtils {
    private static Map<String, String> rawCookieToMap(String cookie) {
        if (StringUtils.isNotBlank((CharSequence)cookie)) {
            return Stream.of(cookie.split("; ")).map(pair -> pair.split("=")).collect(Collectors.toMap(kv -> kv[0], kv -> kv[1]));
        }
        return Collections.emptyMap();
    }

    public static List<String> get(String cookie, String ... name) {
        Map<String, String> cookies = HttpUtils.rawCookieToMap(cookie);
        return Stream.of(name).map(cookies::get).toList();
    }

    public static String getAny(String cookie, String ... name) {
        List<String> result = HttpUtils.get(cookie, name);
        return CollectionUtils.isNotEmpty(result) ? result.getFirst() : null;
    }

    public static String get(String cookie, String name) {
        Map<String, String> cookies = HttpUtils.rawCookieToMap(cookie);
        return cookies.get(name);
    }

    public static boolean isGetRequest(HttpMethod method) {
        return method == HttpMethod.GET;
    }

    public static Boolean isPostRequest(HttpMethod method, String contentType) {
        return !(method != HttpMethod.POST && method != HttpMethod.PUT || !"application/x-www-form-urlencoded".equalsIgnoreCase(contentType) && !"application/json".equals(contentType));
    }
}

