/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.web.core.reactive.utils;

import cn.herodotus.stirrup.web.core.reactive.definition.RequestBodyModifier;
import cn.herodotus.stirrup.web.core.reactive.utils.HeaderUtils;
import cn.herodotus.stirrup.web.core.reactive.utils.RequestBodyUtils;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.ObjectUtils;
import org.dromara.hutool.core.util.ByteUtil;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ExchangeUtils {
    public static URI getRequestURI(ServerWebExchange exchange) {
        return exchange.getRequest().getURI();
    }

    public static String getRequestPath(ServerWebExchange exchange) {
        return exchange.getRequest().getURI().getPath();
    }

    public static HttpMethod getHttpMethod(ServerWebExchange exchange) {
        return exchange.getRequest().getMethod();
    }

    public static ServerHttpRequest decorateRequest(ServerHttpRequest request, final HttpHeaders headers, final Flux<DataBuffer> body) {
        return new ServerHttpRequestDecorator(request){

            public HttpHeaders getHeaders() {
                return headers;
            }

            public Flux<DataBuffer> getBody() {
                return body;
            }
        };
    }

    public static ServerHttpRequest createNewRequest(ServerWebExchange exchange) {
        return ExchangeUtils.createNewRequest(exchange, null);
    }

    public static ServerHttpRequest createNewRequest(ServerWebExchange exchange, URI uri) {
        if (ObjectUtils.isEmpty((Object)uri)) {
            uri = ExchangeUtils.getRequestURI(exchange);
        }
        return exchange.getRequest().mutate().uri(uri).build();
    }

    public static ServerWebExchange createNewExchange(ServerWebExchange exchange, ServerHttpRequest request) {
        return exchange.mutate().request(request).build();
    }

    public static ServerWebExchange createNewExchange(ServerWebExchange exchange, URI uri) {
        ServerHttpRequest request = ExchangeUtils.createNewRequest(exchange, uri);
        return ExchangeUtils.createNewExchange(exchange, request);
    }

    public static ServerWebExchange createNewExchange(ServerWebExchange exchange, String requestBody) {
        ServerHttpRequest request = ExchangeUtils.createNewRequest(exchange);
        Flux<DataBuffer> bodyFlux = RequestBodyUtils.stringToFlux(requestBody);
        HttpHeaders headers = HeaderUtils.resetContentLength(exchange, Array.getLength(ByteUtil.toUtf8Bytes((CharSequence)requestBody)));
        request = ExchangeUtils.decorateRequest(request, headers, bodyFlux);
        return ExchangeUtils.createNewExchange(exchange, request);
    }

    public static ServerWebExchange createNewExchange(ServerWebExchange exchange, HttpHeaders headers, Flux<DataBuffer> body) {
        ServerHttpRequest mutatedRequest = ExchangeUtils.decorateRequest(exchange.getRequest(), headers, body);
        return ExchangeUtils.createNewExchange(exchange, mutatedRequest);
    }

    public static Mono<Void> modify(ServerWebExchange exchange, RequestBodyModifier modifier, Function<ServerWebExchange, Mono<Void>> onFinish, Function<ServerWebExchange, Mono<Void>> onError) {
        return DataBufferUtils.join((Publisher)exchange.getRequest().getBody()).switchIfEmpty(onFinish.apply(exchange).then(Mono.empty())).map(RequestBodyUtils::toString).map(originalBody -> Optional.ofNullable((String)modifier.apply(exchange, originalBody))).flatMap(newBody -> newBody.isPresent() ? (Mono)onFinish.apply(ExchangeUtils.createNewExchange(exchange, (String)newBody.get())) : (Mono)onError.apply(exchange));
    }

    public static boolean isJson(String contentType) {
        return "application/json".equalsIgnoreCase(contentType) || "application/json;charset=UTF-8".equalsIgnoreCase(contentType);
    }

    public static boolean isJson(ServerWebExchange exchange) {
        String contentType = HeaderUtils.getContentType(exchange);
        return ExchangeUtils.isJson(contentType);
    }

    public static boolean isFormUrlencoded(String contentType) {
        return "application/x-www-form-urlencoded".equalsIgnoreCase(contentType);
    }

    public static boolean isFormUrlencoded(ServerWebExchange exchange) {
        String contentType = HeaderUtils.getContentType(exchange);
        return ExchangeUtils.isJson(contentType);
    }

    public static boolean isGetTypeRequest(HttpMethod method) {
        return method == HttpMethod.GET || method == HttpMethod.DELETE;
    }

    public static boolean isGetTypeRequest(ServerWebExchange exchange) {
        HttpMethod method = ExchangeUtils.getHttpMethod(exchange);
        return ExchangeUtils.isGetTypeRequest(method);
    }

    public static Boolean isPostTypeRequest(HttpMethod method, String contentType) {
        return !(method != HttpMethod.POST && method != HttpMethod.PUT || !ExchangeUtils.isFormUrlencoded(contentType) && !ExchangeUtils.isJson(contentType));
    }

    public static Boolean isPostTypeRequest(ServerWebExchange exchange) {
        HttpMethod method = ExchangeUtils.getHttpMethod(exchange);
        String contentType = HeaderUtils.getContentType(exchange);
        return ExchangeUtils.isPostTypeRequest(method, contentType);
    }
}

