/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.web.core.servlet.utils;

import cn.herodotus.stirrup.web.core.definition.utils.HttpUtils;
import cn.herodotus.stirrup.web.core.servlet.utils.HeaderUtils;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.web.util.WebUtils;

public class CookieUtils
extends HttpUtils {
    public static Cookie getCookie(HttpServletRequest httpServletRequest, String name) {
        return WebUtils.getCookie((HttpServletRequest)httpServletRequest, (String)name);
    }

    public static String get(HttpServletRequest httpServletRequest, String name) {
        Cookie cookie = CookieUtils.getCookie(httpServletRequest, name);
        return ObjectUtils.isNotEmpty((Object)cookie) ? cookie.getValue() : null;
    }

    public static String getFromCookieHeader(HttpServletRequest httpServletRequest, String name) {
        String cookie = HeaderUtils.getCookie(httpServletRequest);
        return CookieUtils.get(cookie, name);
    }

    public static String getFromCookieHeader(ServerHttpRequest serverHttpRequest, String name) {
        String cookie = HeaderUtils.getCookie(serverHttpRequest);
        return CookieUtils.get(cookie, name);
    }

    public static String getFromCookieHeader(HttpInputMessage httpInputMessage, String name) {
        String cookie = HeaderUtils.getCookie(httpInputMessage);
        return CookieUtils.get(cookie, name);
    }

    public static String getAnyFromCookieHeader(HttpServletRequest httpServletRequest, String ... name) {
        String cookie = HeaderUtils.getCookie(httpServletRequest);
        return CookieUtils.getAny(cookie, name);
    }

    public static String getAnyFromCookieHeader(ServerHttpRequest serverHttpRequest, String ... name) {
        String cookie = HeaderUtils.getCookie(serverHttpRequest);
        return CookieUtils.getAny(cookie, name);
    }

    public static String getAnyFromCookieHeader(HttpInputMessage httpInputMessage, String ... name) {
        String cookie = HeaderUtils.getCookie(httpInputMessage);
        return CookieUtils.getAny(cookie, name);
    }

    public static void remove(HttpServletResponse response, String key) {
        CookieUtils.set(response, key, null, 0);
    }

    public static void set(HttpServletResponse response, String name, String value, int maxAgeInSeconds) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
    }
}

