/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.web.core.servlet.utils;

import cn.herodotus.stirrup.core.foundation.json.jackson2.utils.Jackson2Utils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;

public class ResponseUtils {
    private static final Logger log = LoggerFactory.getLogger(ResponseUtils.class);

    public static void renderJson(HttpServletResponse response, Object object) {
        ResponseUtils.renderJson(response, Jackson2Utils.toJson((Object)object), MediaType.APPLICATION_JSON.toString());
    }

    public static void renderJson(HttpServletResponse response, String string, String type) {
        try {
            response.setContentType(type);
            response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
            response.getWriter().print(string);
            response.getWriter().flush();
            response.getWriter().close();
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Render response to Json error!");
        }
    }
}

