/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.adapter.alibaba.dubbo;

import cn.hippo4j.adapter.base.ThreadPoolAdapter;
import cn.hippo4j.adapter.base.ThreadPoolAdapterParameter;
import cn.hippo4j.adapter.base.ThreadPoolAdapterState;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.store.DataStore;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;

public class AlibabaDubboThreadPoolAdapter
implements ThreadPoolAdapter,
ApplicationListener<ApplicationStartedEvent> {
    private static final Logger log = LoggerFactory.getLogger(AlibabaDubboThreadPoolAdapter.class);
    private final Map<String, ThreadPoolExecutor> DUBBO_PROTOCOL_EXECUTOR = Maps.newHashMap();

    public String mark() {
        return "AlibabaDubbo";
    }

    public ThreadPoolAdapterState getThreadPoolState(String identify) {
        ThreadPoolAdapterState threadPoolAdapterState = new ThreadPoolAdapterState();
        ThreadPoolExecutor executor = this.DUBBO_PROTOCOL_EXECUTOR.get(identify);
        if (executor == null) {
            log.warn("[{}] Alibaba Dubbo consuming thread pool not found.", (Object)identify);
            return threadPoolAdapterState;
        }
        threadPoolAdapterState.setThreadPoolKey(identify);
        threadPoolAdapterState.setCoreSize(Integer.valueOf(executor.getCorePoolSize()));
        threadPoolAdapterState.setMaximumSize(Integer.valueOf(executor.getMaximumPoolSize()));
        return threadPoolAdapterState;
    }

    public List<ThreadPoolAdapterState> getThreadPoolStates() {
        ArrayList<ThreadPoolAdapterState> threadPoolAdapterStates = new ArrayList<ThreadPoolAdapterState>();
        this.DUBBO_PROTOCOL_EXECUTOR.forEach((kel, val) -> threadPoolAdapterStates.add(this.getThreadPoolState(String.valueOf(val))));
        return threadPoolAdapterStates;
    }

    public boolean updateThreadPool(ThreadPoolAdapterParameter threadPoolAdapterParameter) {
        String threadPoolKey = threadPoolAdapterParameter.getThreadPoolKey();
        ThreadPoolExecutor executor = this.DUBBO_PROTOCOL_EXECUTOR.get(threadPoolAdapterParameter.getThreadPoolKey());
        if (executor == null) {
            log.warn("[{}] Alibaba Dubbo consuming thread pool not found.", (Object)threadPoolKey);
            return false;
        }
        int originalCoreSize = executor.getCorePoolSize();
        int originalMaximumPoolSize = executor.getMaximumPoolSize();
        executor.setCorePoolSize(threadPoolAdapterParameter.getCorePoolSize());
        executor.setMaximumPoolSize(threadPoolAdapterParameter.getMaximumPoolSize());
        log.info("[{}] Alibaba Dubbo consumption thread pool parameter change. coreSize: {}, maximumSize: {}", new Object[]{threadPoolKey, String.format("%s => %s", originalCoreSize, executor.getCorePoolSize()), String.format("%s => %s", originalMaximumPoolSize, executor.getMaximumPoolSize())});
        return true;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        String poolKey = ExecutorService.class.getName();
        try {
            DataStore dataStore = (DataStore)ExtensionLoader.getExtensionLoader(DataStore.class).getDefaultExtension();
            Map executors = dataStore.get(poolKey);
            executors.forEach((key, value) -> this.DUBBO_PROTOCOL_EXECUTOR.put((String)key, (ThreadPoolExecutor)value));
        }
        catch (Exception ex) {
            log.error("Failed to get Alibaba Dubbo protocol thread pool", (Throwable)ex);
        }
    }
}

