/*
 * Decompiled with CFR 0.152.
 */
package cn.hll520.linling.biliClient;

import cn.hll520.linling.biliClient.client.BaseClient;
import cn.hll520.linling.biliClient.client.BaseClientFactory;
import cn.hll520.linling.biliClient.exception.BiliRequestException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiliRequest {
    private static final Logger log = LoggerFactory.getLogger(BiliRequest.class);
    private final BaseClient baseClient;
    private final URIBuilder uriBuilder;

    public BiliRequest() {
        this.baseClient = BaseClientFactory.getBaseClient();
        this.uriBuilder = new URIBuilder().setScheme(this.baseClient.getProtocol()).setHost(this.baseClient.getHost()).setPort(this.baseClient.getPort());
    }

    public BiliRequest(BaseClient client, String version) {
        this.baseClient = client;
        this.uriBuilder = new URIBuilder().setScheme(client.getProtocol()).setHost(client.getHost()).setPort(client.getPort());
    }

    public BiliRequest useHostVC() {
        this.uriBuilder.setHost(this.baseClient.getHostVC());
        return this;
    }

    public BiliRequest setHost(String host) {
        this.uriBuilder.setHost(host);
        return this;
    }

    public BiliRequest setPath(String path) {
        this.uriBuilder.setPath(path);
        return this;
    }

    public BiliRequest setParams(String key, String value) {
        this.uriBuilder.setParameter(key, value);
        return this;
    }

    public BiliRequest setParams(String key, Object value) {
        this.uriBuilder.setParameter(key, value == null ? "" : value.toString());
        return this;
    }

    public BiliRequest setParams(List<NameValuePair> params) {
        this.uriBuilder.setParameters(params);
        return this;
    }

    public URI getURI() {
        try {
            return this.uriBuilder.build();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            log.error("\u6784\u5efaURI\u9519\u8bef");
            throw new BiliRequestException(this.uriBuilder.getPath(), "URI\u6784\u5efa\u9519\u8bef");
        }
    }

    public BaseClient getBaseClient() {
        return this.baseClient;
    }

    public String getRequestPath() {
        return this.uriBuilder.getScheme() + "://" + this.uriBuilder.getHost() + ":" + this.uriBuilder.getPort() + this.uriBuilder.getPath();
    }
}

