/*
 * Decompiled with CFR 0.152.
 */
package cn.hll520.linling.biliClient.utils;

import cn.hll520.linling.biliClient.BiliClient;
import cn.hll520.linling.biliClient.BiliClientFactor;
import cn.hll520.linling.biliClient.model.dynamic.Dynamic;
import cn.hll520.linling.biliClient.model.user.User;
import cn.hll520.linling.biliClient.model.video.Video;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransViewUri {
    private static final Logger log = LoggerFactory.getLogger(TransViewUri.class);

    public static String trans(User user) {
        return "https://space.bilibili.com/" + user.getMid();
    }

    public static String trans(Dynamic dynamic) {
        if (dynamic != null && dynamic.getData() != null) {
            return "https://t.bilibili.com/" + dynamic.getData().getDynamic_id();
        }
        return null;
    }

    public static String trans(Video video) {
        if (video != null) {
            if (!video.getBvid().isEmpty()) {
                return "https://www.bilibili.com/video/" + video.getBvid();
            }
            if (video.getAid() != 0L) {
                return "https://www.bilibili.com/video/av" + video.getAid();
            }
        }
        return null;
    }

    public static String AvidToBvid(long avid) {
        Video video = null;
        try {
            BiliClient biliClient = BiliClientFactor.getClient();
            video = biliClient.video().withAvid(avid).get();
            if (video != null) {
                return video.getBvid();
            }
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u9519\u8bef\uff0c\u539f\u59cbid\u4e3a {},\u5bf9\u4e8e\u89c6\u9891\u4fe1\u606f\u4e3a{},\u9519\u8bef\u539f\u56e0\u4e3a{}", new Object[]{avid, video, e});
            e.printStackTrace();
        }
        return null;
    }

    public static long BvidToAvid(String bvid) {
        Video video = null;
        try {
            BiliClient biliClient = BiliClientFactor.getClient();
            video = biliClient.video().withBvid(bvid).get();
            if (video != null) {
                return video.getAid();
            }
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u9519\u8bef\uff0c\u539f\u59cbid\u4e3a {},\u5bf9\u4e8e\u89c6\u9891\u4fe1\u606f\u4e3a{},\u9519\u8bef\u539f\u56e0\u4e3a{}", new Object[]{bvid, video, e});
            e.printStackTrace();
        }
        return 0L;
    }
}

