/*
 * Decompiled with CFR 0.152.
 */
package cn.hll520.linling.biliClient.utils.dynamic;

import cn.hll520.linling.biliClient.model.dynamic.Dynamic;
import java.util.ArrayList;
import java.util.List;

public class DynamicInfo {
    protected List<Dynamic> dynamics = new ArrayList<Dynamic>();
    protected long viewAll;
    protected long likeAll;
    protected long repostAll;
    protected long commentAll;
    protected long coinAll;
    protected long count;

    public DynamicInfo() {
    }

    public DynamicInfo(List<Dynamic> dynamics) {
        this();
        this.dynamics = dynamics;
    }

    public DynamicInfo analyze() {
        if (this.dynamics != null && !this.dynamics.isEmpty()) {
            this.dynamics.forEach(dynamic -> {
                this.viewAll += dynamic.getData().getView();
                this.likeAll += dynamic.getData().getLike();
                this.repostAll += dynamic.getData().getRepost();
                this.commentAll += dynamic.getData().getComment();
                if (dynamic.getType() == Dynamic.DType.VIDEO) {
                    this.coinAll += dynamic.getVideo().getStat().getCoin();
                }
            });
            this.count = this.dynamics.size();
        }
        return this;
    }

    public List<Dynamic> getDynamics() {
        return this.dynamics;
    }

    public long getViewAll() {
        return this.viewAll;
    }

    public long getLikeAll() {
        return this.likeAll;
    }

    public long getRepostAll() {
        return this.repostAll;
    }

    public long getCommentAll() {
        return this.commentAll;
    }

    public long getCoinAll() {
        return this.coinAll;
    }

    public long getCount() {
        return this.count;
    }

    public void setDynamics(List<Dynamic> dynamics) {
        this.dynamics = dynamics;
    }

    public void setViewAll(long viewAll) {
        this.viewAll = viewAll;
    }

    public void setLikeAll(long likeAll) {
        this.likeAll = likeAll;
    }

    public void setRepostAll(long repostAll) {
        this.repostAll = repostAll;
    }

    public void setCommentAll(long commentAll) {
        this.commentAll = commentAll;
    }

    public void setCoinAll(long coinAll) {
        this.coinAll = coinAll;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicInfo)) {
            return false;
        }
        DynamicInfo other = (DynamicInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Dynamic> this$dynamics = this.getDynamics();
        List<Dynamic> other$dynamics = other.getDynamics();
        if (this$dynamics == null ? other$dynamics != null : !((Object)this$dynamics).equals(other$dynamics)) {
            return false;
        }
        if (this.getViewAll() != other.getViewAll()) {
            return false;
        }
        if (this.getLikeAll() != other.getLikeAll()) {
            return false;
        }
        if (this.getRepostAll() != other.getRepostAll()) {
            return false;
        }
        if (this.getCommentAll() != other.getCommentAll()) {
            return false;
        }
        if (this.getCoinAll() != other.getCoinAll()) {
            return false;
        }
        return this.getCount() == other.getCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamicInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Dynamic> $dynamics = this.getDynamics();
        result = result * 59 + ($dynamics == null ? 43 : ((Object)$dynamics).hashCode());
        long $viewAll = this.getViewAll();
        result = result * 59 + (int)($viewAll >>> 32 ^ $viewAll);
        long $likeAll = this.getLikeAll();
        result = result * 59 + (int)($likeAll >>> 32 ^ $likeAll);
        long $repostAll = this.getRepostAll();
        result = result * 59 + (int)($repostAll >>> 32 ^ $repostAll);
        long $commentAll = this.getCommentAll();
        result = result * 59 + (int)($commentAll >>> 32 ^ $commentAll);
        long $coinAll = this.getCoinAll();
        result = result * 59 + (int)($coinAll >>> 32 ^ $coinAll);
        long $count = this.getCount();
        result = result * 59 + (int)($count >>> 32 ^ $count);
        return result;
    }

    public String toString() {
        return "DynamicInfo(dynamics=" + this.getDynamics() + ", viewAll=" + this.getViewAll() + ", likeAll=" + this.getLikeAll() + ", repostAll=" + this.getRepostAll() + ", commentAll=" + this.getCommentAll() + ", coinAll=" + this.getCoinAll() + ", count=" + this.getCount() + ")";
    }
}

