/*
 * Decompiled with CFR 0.152.
 */
package cn.hll520.linling.core;

import cn.hll520.linling.core.autovalue.ShiroInfoValue;
import cn.hll520.linling.core.util.PathUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class LinlingCoreExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(LinlingCoreExceptionHandler.class);
    private final ShiroInfoValue value;

    public LinlingCoreExceptionHandler(ShiroInfoValue value) {
        this.value = value;
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    public String unPromise(Exception e) {
        log.error("\u51fa\u73b0\u9519\u8bef{},\u672a\u6388\u6743\u7684\u8bbf\u95ee\uff01", (Object)e.getMessage());
        return PathUtils.forward(this.value.getUnAuthorizedUrl());
    }

    @ExceptionHandler(value={AuthorizationException.class})
    public String unLogin(Exception e) {
        log.error("\u51fa\u73b0\u9519\u8bef{},\u672a\u767b\u5f55\u7684\u8bbf\u95ee\uff01", (Object)e.getMessage());
        return PathUtils.redirect(this.value.getUnLoginUrl());
    }
}

