/*
 * Decompiled with CFR 0.152.
 */
package cn.hll520.linling.core;

import cn.hll520.linling.core.autovalue.AppHostValue;
import cn.hll520.linling.core.util.PathUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class LinlingCoreWebMvcHandler
implements WebMvcConfigurer {
    private final AppHostValue value;

    public LinlingCoreWebMvcHandler(AppHostValue value) {
        this.value = value;
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        this.checkAdd(registry, this.value.getAppInfoHost(), "/linling/info.html", true);
        this.checkAdd(registry, this.value.getAppDefaultLoginHost(), "/linling/login.html", true);
        this.checkAdd(registry, this.value.getAppCoreManageHost(), "/linling/manage.html", true);
        this.checkAdd(registry, this.value.getAppApiHost(), "/swagger-ui/index.html", false);
        this.checkAdd(registry, this.value.getAppSQLManageHost(), "/druid/login.html", false);
    }

    private void checkAdd(ViewControllerRegistry registry, String path, String defaultPath, boolean isForward) {
        if (registry == null || path == null || defaultPath == null) {
            return;
        }
        if (!defaultPath.equals(path)) {
            if (isForward) {
                registry.addViewController(path).setViewName(PathUtils.forward(defaultPath));
            } else {
                registry.addViewController(path).setViewName(PathUtils.redirect(defaultPath));
            }
        }
    }
}

