/*
 * Decompiled with CFR 0.152.
 */
package cn.hll520.linling.core.api;

import cn.hll520.linling.core.object.Result;
import cn.hll520.linling.core.object.safety.UserBase;
import cn.hll520.linling.core.util.ResultUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u670d\u52a1\u8ba4\u8bc1"})
@RestController
@RequestMapping(value={"linling/identity"})
public class AppIdentityApi {
    @ApiOperation(value="\u83b7\u53d6\u4fe1\u606f")
    @GetMapping
    public Result<UserBase> identity() {
        try {
            Subject subject = SecurityUtils.getSubject();
            Object principal = subject.getPrincipal();
            if (principal == null) {
                return ResultUtils.noLogin("\u672a\u767b\u5f55\uff01");
            }
            return ResultUtils.success((UserBase)principal);
        }
        catch (Exception e) {
            return ResultUtils.error(e);
        }
    }

    @ApiOperation(value="\u767b\u5f55", notes="\u5fc5\u987b\u5177\u6709username\u548cpassword")
    @PostMapping(value={"/login"})
    public Result<UserBase> login(UserBase user, boolean remember) {
        try {
            if (user == null || user.getUsername() == null || user.getPassword() == null) {
                return ResultUtils.fail(user, "\u7528\u6237\u540d\u548c\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            UsernamePasswordToken token = new UsernamePasswordToken(user.getUsername(), user.getPassword(), remember);
            Subject subject = SecurityUtils.getSubject();
            subject.login((AuthenticationToken)token);
            return ResultUtils.success((UserBase)subject.getPrincipal());
        }
        catch (UnknownAccountException e) {
            return ResultUtils.fail(user, "\u7528\u6237\u4e0d\u5b58\u5728!\n");
        }
        catch (IncorrectCredentialsException e) {
            return ResultUtils.fail(user, "\u5bc6\u7801\u9519\u8bef!\n");
        }
        catch (Exception e) {
            return ResultUtils.error(e);
        }
    }

    @ApiOperation(value="\u9000\u51fa\u767b\u5f55")
    @GetMapping(value={"/logout"})
    public Result<Boolean> logout() {
        try {
            Subject subject = SecurityUtils.getSubject();
            subject.logout();
            return ResultUtils.bool(true);
        }
        catch (Exception e) {
            return ResultUtils.error(e);
        }
    }
}

