/*
 * Decompiled with CFR 0.152.
 */
package cn.hll520.linling.core.api;

import cn.hll520.linling.core.autovalue.AppHostValue;
import cn.hll520.linling.core.autovalue.AppInfoValue;
import cn.hll520.linling.core.object.Result;
import cn.hll520.linling.core.util.ResultUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u670d\u52a1\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/linling/core/appInfo"})
public class AppInfoApi {
    private final AppInfoValue infoValue;
    private final AppHostValue hostValue;

    public AppInfoApi(AppInfoValue infoValue, AppHostValue hostValue) {
        this.infoValue = infoValue;
        this.hostValue = hostValue;
    }

    @ApiOperation(value="\u670d\u52a1\u5168\u90e8\u4fe1\u606f", notes="info \u4e3ainfo host \u4e3a host")
    @GetMapping
    public Result<Map<String, Object>> getAppInfo() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("infos", this.infoValue);
            map.put("hosts", this.hostValue);
            return ResultUtils.success(map);
        }
        catch (Exception e) {
            return ResultUtils.error(e);
        }
    }

    @ApiOperation(value="\u670d\u52a1\u4fe1\u606f")
    @GetMapping(value={"/info"})
    public Result<AppInfoValue> infoValueResult() {
        try {
            return ResultUtils.success(this.infoValue);
        }
        catch (Exception e) {
            return ResultUtils.error(e);
        }
    }

    @ApiOperation(value="\u670d\u52a1\u76f8\u5173\u5730\u5740")
    @GetMapping(value={"/hosts"})
    public Result<AppHostValue> hostValueResult() {
        try {
            return ResultUtils.success(this.hostValue);
        }
        catch (Exception e) {
            return ResultUtils.error(e);
        }
    }

    @ApiOperation(value="\u670d\u52a1\u7248\u672c")
    @GetMapping(value={"/version"})
    public Result<String> getAppVersion() {
        try {
            return ResultUtils.success(this.infoValue.getAppVersion());
        }
        catch (Exception e) {
            return ResultUtils.error(e);
        }
    }

    @ApiOperation(value="\u670d\u52a1\u9996\u9875")
    @GetMapping(value={"/host"})
    public Result<String> getAppHost() {
        try {
            return ResultUtils.success(this.infoValue.getAppHost());
        }
        catch (Exception e) {
            return ResultUtils.error(e);
        }
    }

    @ApiOperation(value="\u670d\u52a1\u4fe1\u606f\u9875")
    @GetMapping(value={"/infoHost"})
    public Result<String> getAppInfoHost() {
        try {
            return ResultUtils.success(this.hostValue.getAppInfoHost());
        }
        catch (Exception e) {
            return ResultUtils.error(e);
        }
    }
}

