/*
 * Decompiled with CFR 0.152.
 */
package cn.hll520.linling.core.config;

import cn.hll520.linling.core.autovalue.AppHostValue;
import cn.hll520.linling.core.autovalue.AppInfoValue;
import cn.hll520.linling.core.autovalue.AppManageValue;
import cn.hll520.linling.core.object.Menu;
import cn.hll520.linling.core.object.MenuGroup;
import cn.hll520.linling.core.service.IManageServer;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class AppManageConfig {
    private final AppManageValue value;
    private final AppInfoValue infoValue;
    private final AppHostValue hostValue;
    private final IManageServer manageServer;

    public AppManageConfig(AppManageValue value, AppInfoValue infoValue, AppHostValue hostValue, IManageServer manageServer) {
        this.value = value;
        this.infoValue = infoValue;
        this.hostValue = hostValue;
        this.manageServer = manageServer;
    }

    public AppManageValue getManage() {
        List<Menu> navbar = this.value.getNavbar() == null ? this.defaultMenus() : this.value.getNavbar();
        this.value.setNavbar(this.manageServer.topMenu(navbar));
        List<MenuGroup> menuGroups = this.value.getMenu() == null ? this.defaultGroupMenus() : this.value.getMenu();
        this.value.setMenu(this.manageServer.leftMenu(menuGroups));
        this.value.setWelcome(this.manageServer.welcome(this.value.getMenu(), this.value.getWelcome()));
        for (Menu menu : this.value.getNavbar()) {
            if (menu.getTarget() != null) continue;
            menu.setTarget("_view");
        }
        for (MenuGroup menuGroup : this.value.getMenu()) {
            if (menuGroup == null) continue;
            for (Menu menu : menuGroup.getMenus()) {
                if (menu.getTarget() != null) continue;
                menu.setTarget("_view");
            }
        }
        this.manageServer.modify(this.value, this.infoValue, this.defaultMenus());
        return this.value;
    }

    private List<Menu> defaultMenus() {
        ArrayList<Menu> defaultMenus = new ArrayList<Menu>();
        defaultMenus.add(new Menu("\u5173\u4e8e\u5e94\u7528", this.hostValue.getAppInfoHost()));
        defaultMenus.add(new Menu("API\u63a5\u53e3", this.hostValue.getAppApiHost()));
        defaultMenus.add(new Menu("SQL\u76d1\u63a7", this.hostValue.getAppSQLManageHost()));
        return defaultMenus;
    }

    private List<MenuGroup> defaultGroupMenus() {
        ArrayList<MenuGroup> menuGroups = new ArrayList<MenuGroup>();
        MenuGroup menuGroup = new MenuGroup();
        menuGroup.setName("defaultMenu");
        menuGroup.setMenus(this.defaultMenus());
        menuGroups.add(menuGroup);
        this.value.setMenu(menuGroups);
        return menuGroups;
    }
}

