/*
 * Decompiled with CFR 0.152.
 */
package cn.hll520.linling.core.config;

import cn.hll520.linling.core.autovalue.DruidInfoValue;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DruidConfig {
    private final DruidInfoValue value;

    public DruidConfig(DruidInfoValue value) {
        this.value = value;
    }

    @Bean
    public ServletRegistrationBean druidServlet() {
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean((Servlet)new StatViewServlet(), new String[]{"/druid/*"});
        servletRegistrationBean.addInitParameter("loginUsername", this.value.getUsername());
        servletRegistrationBean.addInitParameter("loginPassword", this.value.getPassword());
        servletRegistrationBean.addInitParameter("resetEnable", String.valueOf(this.value.isRestEnable()));
        return servletRegistrationBean;
    }

    @Bean
    public FilterRegistrationBean filterRegistrationBean() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new WebStatFilter(), new ServletRegistrationBean[0]);
        filterRegistrationBean.addUrlPatterns(new String[]{this.value.getUrlPatterns()});
        filterRegistrationBean.addInitParameter("exclusions", "*.js,*.gif,*.jpg,*.png,*.css,*.ico,/druid/*");
        return filterRegistrationBean;
    }
}

