/*
 * Decompiled with CFR 0.152.
 */
package cn.hll520.linling.core.config;

import cn.hll520.linling.core.autovalue.ShiroInfoValue;
import cn.hll520.linling.core.service.IFilterUrlServer;
import cn.hll520.linling.core.service.impl.DefaultCoreRealmServer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.MemoryConstrainedCacheManager;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.mgt.RememberMeManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.CookieRememberMeManager;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShiroConfig {
    private final ShiroInfoValue value;
    private final DefaultCoreRealmServer realm;
    private final IFilterUrlServer filterUrlServer;

    public ShiroConfig(ShiroInfoValue value, DefaultCoreRealmServer realm, IFilterUrlServer filterUrlServer) {
        this.value = value;
        this.realm = realm;
        this.filterUrlServer = filterUrlServer;
    }

    @Bean
    public ShiroFilterFactoryBean getShiroFilterFactoryBean(@Qualifier(value="SecurityManager") DefaultWebSecurityManager securityManager) {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager((SecurityManager)securityManager);
        LinkedHashMap<String, String> filterMap = new LinkedHashMap<String, String>();
        filterMap.put("/linling/core/identity/**", "anon");
        filterMap.put("/linling/core/appInfo/**", "anon");
        filterMap.put("/linling/core", "anon");
        filterMap.put("/linling/core/**", "user");
        Map<String, String> map = this.filterUrlServer.filterUrl(filterMap, this.value);
        shiroFilterFactoryBean.setFilterChainDefinitionMap(map);
        shiroFilterFactoryBean.setLoginUrl(this.value.getUnLoginUrl());
        shiroFilterFactoryBean.setUnauthorizedUrl(this.value.getUnAuthorizedUrl());
        return shiroFilterFactoryBean;
    }

    @Bean(value={"SecurityManager"})
    public DefaultWebSecurityManager getDefaultWebSecurityManager(@Qualifier(value="realm") DefaultCoreRealmServer realm) {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm((Realm)realm);
        securityManager.setRememberMeManager((RememberMeManager)this.rememberMeManager());
        return securityManager;
    }

    @Bean(value={"realm"})
    public DefaultCoreRealmServer getUserRealm() {
        this.realm.setCacheManager((CacheManager)new MemoryConstrainedCacheManager());
        this.realm.setCachingEnabled(this.value.getCaching().isCachingEnable());
        this.realm.setAuthenticationCachingEnabled(this.value.getCaching().isAuthenticationCachingEnabled());
        this.realm.setAuthorizationCachingEnabled(this.value.getCaching().isAuthorizationCachingEnabled());
        this.realm.setAuthorizationCacheName(this.value.getCaching().getCacheName());
        return this.realm;
    }

    @Bean
    public SimpleCookie rememberMeCookie() {
        SimpleCookie simpleCookie = new SimpleCookie(this.value.getRemember().getRememberCookieName());
        simpleCookie.setHttpOnly(this.value.getRemember().isRememberOnlyHttp());
        simpleCookie.setPath(this.value.getRemember().getRememberPath());
        simpleCookie.setMaxAge(this.value.getRemember().getRememberTime());
        return simpleCookie;
    }

    @Bean
    public CookieRememberMeManager rememberMeManager() {
        CookieRememberMeManager cookieRememberMeManager = new CookieRememberMeManager();
        cookieRememberMeManager.setCookie((Cookie)this.rememberMeCookie());
        cookieRememberMeManager.setCipherKey(Base64.decode((String)this.value.getRemember().getRememberBase64Encode()));
        return cookieRememberMeManager;
    }

    @Bean
    public DefaultAdvisorAutoProxyCreator defaultAdvisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator proxyCreator = new DefaultAdvisorAutoProxyCreator();
        proxyCreator.setProxyTargetClass(this.value.isEnableAnnotation());
        return proxyCreator;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(@Qualifier(value="SecurityManager") DefaultWebSecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor = new AuthorizationAttributeSourceAdvisor();
        authorizationAttributeSourceAdvisor.setSecurityManager((SecurityManager)securityManager);
        return authorizationAttributeSourceAdvisor;
    }
}

