/*
 * Decompiled with CFR 0.152.
 */
package cn.hll520.linling.core.config;

import cn.hll520.linling.core.autovalue.AppInfoValue;
import cn.hll520.linling.core.autovalue.SwaggerInfoValue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class SwaggerConfig {
    private final SwaggerInfoValue value;
    private final AppInfoValue appValue;

    public SwaggerConfig(SwaggerInfoValue value, AppInfoValue appValue) {
        this.value = value;
        this.appValue = appValue;
    }

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).enable(this.value.isEnable()).select().apis(RequestHandlerSelectors.basePackage((String)this.value.getBasePackagePath())).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.value.getTitle() == null ? this.appValue.getAppName() + " API\u6587\u6863" : this.value.getTitle()).description(this.value.getDescription() == null ? this.appValue.getAppDescription() : this.value.getDescription()).termsOfServiceUrl(this.value.getUrl() == null ? this.appValue.getAppHost() : this.value.getUrl()).version(this.value.getVersion() == null ? this.appValue.getAppVersion() : this.value.getVersion()).build();
    }
}

