/*
 * Decompiled with CFR 0.152.
 */
package cn.hll520.linling.core.object;

import cn.hll520.linling.core.object.Order;

public class QueryParams {
    private Integer limit = 20;
    private Integer offset = 0;
    private Integer page = 0;
    private String orderBy;
    private Order order = Order.DESC;

    public QueryParams() {
    }

    public QueryParams(Integer page) {
        this();
        this.page = page == null ? 0 : page;
        this.offset = this.page * this.limit;
    }

    public QueryParams(Integer limit, Integer page) {
        this(page);
        this.limit = limit == null ? 20 : limit;
    }

    public QueryParams(Integer limit, Integer page, String orderBy, Order order) {
        this(limit, page);
        this.orderBy = orderBy;
        this.order = order == null ? Order.DESC : order;
    }

    public static QueryParams build(Integer offset) {
        return QueryParams.build(20, offset);
    }

    public static QueryParams build(Integer limit, Integer offset) {
        return QueryParams.build(limit, offset, null, null);
    }

    public static QueryParams build(Integer limit, Integer offset, String orderBy, Order order) {
        QueryParams queryParams = new QueryParams(limit, limit == null ? offset / 20 : (limit == 0 ? 0 : offset / limit), orderBy, order);
        queryParams.setOffset(offset);
        return queryParams;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getPage() {
        return this.page;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryParams)) {
            return false;
        }
        QueryParams other = (QueryParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Integer this$offset = this.getOffset();
        Integer other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        Integer this$page = this.getPage();
        Integer other$page = other.getPage();
        if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
            return false;
        }
        String this$orderBy = this.getOrderBy();
        String other$orderBy = other.getOrderBy();
        if (this$orderBy == null ? other$orderBy != null : !this$orderBy.equals(other$orderBy)) {
            return false;
        }
        Order this$order = this.getOrder();
        Order other$order = other.getOrder();
        return !(this$order == null ? other$order != null : !((Object)((Object)this$order)).equals((Object)other$order));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Integer $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        Integer $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
        String $orderBy = this.getOrderBy();
        result = result * 59 + ($orderBy == null ? 43 : $orderBy.hashCode());
        Order $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)((Object)$order)).hashCode());
        return result;
    }

    public String toString() {
        return "QueryParams(limit=" + this.getLimit() + ", offset=" + this.getOffset() + ", page=" + this.getPage() + ", orderBy=" + this.getOrderBy() + ", order=" + (Object)((Object)this.getOrder()) + ")";
    }
}

