/*
 * Decompiled with CFR 0.152.
 */
package cn.hll520.linling.core.service.impl;

import cn.hll520.linling.core.object.safety.PromiseBase;
import cn.hll520.linling.core.object.safety.RoleBase;
import cn.hll520.linling.core.object.safety.UserBase;
import cn.hll520.linling.core.service.ILoginServer;
import java.util.List;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultCoreRealmServer
extends AuthorizingRealm {
    @Autowired
    private ILoginServer loginServer;

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo safe = new SimpleAuthorizationInfo();
        Subject subject = SecurityUtils.getSubject();
        UserBase user = (UserBase)subject.getPrincipal();
        List<RoleBase> roles = this.loginServer.checkRole(user);
        if (roles != null) {
            for (RoleBase role : roles) {
                if (role == null) continue;
                safe.addRole(role.getRoleCode());
                List<PromiseBase> promises = this.loginServer.checkPromise(role);
                if (promises == null) continue;
                for (PromiseBase promise : promises) {
                    safe.addStringPermission(promise.getPromiseCode());
                }
            }
        }
        return safe;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        if (token == null) {
            return null;
        }
        UsernamePasswordToken userToken = (UsernamePasswordToken)token;
        if (userToken.getUsername() == null) {
            return null;
        }
        Object userinfo = this.loginServer.login(new UserBase(userToken.getUsername()));
        return new SimpleAuthenticationInfo(userinfo, (Object)((UserBase)userinfo).getPassword(), "");
    }
}

