/*
 * Decompiled with CFR 0.152.
 */
package cn.hll520.linling.core.util;

import cn.hll520.linling.core.exception.ServerException;
import cn.hll520.linling.core.object.Result;

public class ResultUtils {
    public static Result error(Exception exception) {
        if (exception instanceof ServerException) {
            ServerException e = (ServerException)exception;
            return ResultUtils.fail(e.getMessage(), e.getCode());
        }
        return ResultUtils.fail(exception.getMessage());
    }

    public static Result noLogin(String msg) {
        return new Result<Object>(false, 110, "\u8bf7\u5148\u767b\u5f55\uff01" + (msg == null ? "" : msg), null);
    }

    public static Result noPermit(String msg) {
        return new Result<Object>(false, 120, "\u6ca1\u6709\u6743\u9650\uff01" + (msg == null ? "" : msg), null);
    }

    public static Result<Boolean> bool(boolean flag, String msg) {
        return ResultUtils.build(flag, flag, msg);
    }

    public static Result<Boolean> bool(boolean flag) {
        return ResultUtils.build(flag, flag);
    }

    public static <T> Result<T> success(T data) {
        return ResultUtils.success(data, null);
    }

    public static Result success(String msg) {
        return ResultUtils.success(null, msg);
    }

    public static <T> Result<T> success(T data, String msg) {
        return ResultUtils.build(true, data, msg);
    }

    public static Result fail(String msg) {
        return ResultUtils.fail(null, msg);
    }

    public static Result fail(String msg, int code) {
        return ResultUtils.fail(null, msg, code);
    }

    public static <T> Result<T> fail(T data, String msg) {
        return ResultUtils.fail(data, msg, 1000);
    }

    public static <T> Result<T> fail(T data, String msg, int code) {
        return new Result<T>(false, code, msg, data);
    }

    public static <T> Result<T> build(boolean flag, T data) {
        return ResultUtils.build(flag, data, null);
    }

    public static <T> Result<T> build(boolean flag, T data, String msg) {
        return new Result<T>(flag, flag ? 200 : 1000, msg, data);
    }
}

