/*
 * Decompiled with CFR 0.152.
 */
package cn.hollycloud.iplatform.common.controller;

import cn.hollycloud.iplatform.common.bean.PageResult;
import cn.hollycloud.iplatform.common.bean.Result;
import cn.hollycloud.iplatform.common.exception.ServiceFailException;
import cn.hollycloud.iplatform.common.utils.ResultUtils;
import cn.hutool.core.io.IoUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BaseController {
    public Result resultOk() {
        return ResultUtils.resultOk();
    }

    public <T extends Result> T resultOk(Object data) {
        return ResultUtils.resultOk(data);
    }

    public <T extends Result> T resultOk(Object data, String msg) {
        return ResultUtils.resultOk(data, msg);
    }

    public Result resultFail() {
        return ResultUtils.resultFail();
    }

    public Result resultFail(String msg) {
        return ResultUtils.resultFail(msg);
    }

    public Result resultFail(int code, String msg) {
        return ResultUtils.resultFail(code, msg);
    }

    public static PageResult resultPageFail(int code, String msg) {
        return ResultUtils.resultPageFail(code, msg);
    }

    public static PageResult resultPageFail() {
        return ResultUtils.resultPageFail();
    }

    public static PageResult resultPageFail(String msg) {
        return ResultUtils.resultPageFail(msg);
    }

    public void addFileHeader(HttpServletRequest request, HttpServletResponse response, String fileName, String contentType) {
        try {
            String agent = request.getHeader("USER-AGENT").toLowerCase();
            response.setContentType(contentType);
            String codedFileName = URLEncoder.encode(fileName, "UTF-8");
            if (agent.contains("firefox")) {
                response.setCharacterEncoding("utf-8");
                response.setHeader("content-disposition", "attachment;filename=" + new String(fileName.getBytes(), "ISO8859-1"));
            } else {
                response.setHeader("content-disposition", "attachment;filename=" + codedFileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exportFile(InputStream inputStream, HttpServletRequest request, HttpServletResponse response, String fileName, String contentType) {
        try {
            this.addFileHeader(request, response, fileName, contentType);
            ServletOutputStream out = response.getOutputStream();
            IoUtil.copy((InputStream)inputStream, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new ServiceFailException("\u5bfc\u51fa\u5931\u8d25,{}", e);
        }
    }

    public void exportFile(InputStream inputStream, HttpServletRequest request, HttpServletResponse response, String fileName) {
        this.exportFile(inputStream, request, response, fileName, "application/octet-stream");
    }
}

