/*
 * Decompiled with CFR 0.152.
 */
package cn.hollycloud.iplatform.common.utils;

import cn.hollycloud.iplatform.common.bean.Result;
import cn.hollycloud.iplatform.common.utils.JsonUtils;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjaxUtils {
    private static final Logger logger = LoggerFactory.getLogger(AjaxUtils.class);

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String requestType = request.getHeader("X-Requested-With");
        String token = request.getHeader("token");
        return StringUtils.isNotEmpty((CharSequence)requestType) || StringUtils.isNotEmpty((CharSequence)token);
    }

    public static void printMsg(int code, HttpServletResponse response) {
        AjaxUtils.printMsg(code, response, null);
    }

    public static void printMsg(int code, HttpServletResponse response, String msg) {
        AjaxUtils.printMsg(code, response, msg, null);
    }

    public static void printMsg(int code, HttpServletResponse response, String msg, Object data) {
        response.setStatus(200);
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-type", "application/json;charset=UTF-8");
        Result<Object> result = new Result<Object>();
        result.setStatus(code);
        result.setMessage(msg);
        result.setData(data);
        PrintWriter out = null;
        try {
            out = response.getWriter();
            String jsonStr = JsonUtils.serialize(result);
            logger.info("\u8fd4\u56dejson\u6570\u636e{}", (Object)jsonStr);
            out.write(jsonStr);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

