/*
 * Decompiled with CFR 0.152.
 */
package cn.hollycloud.iplatform.common.utils;

import cn.hollycloud.iplatform.common.exception.ServiceFailException;
import cn.hutool.core.util.StrUtil;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class HttpUtils {
    @Autowired(required=false)
    private RestTemplate restTemplate;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private <T> T doRequest(String url, HttpMethod method, HttpEntity requestEntity, Class<T> responseType, ParameterizedTypeReference type) {
        try {
            ResponseEntity responseEntity = null;
            responseEntity = responseType != null ? this.restTemplate.exchange(url, method, requestEntity, responseType, new Object[0]) : this.restTemplate.exchange(url, method, requestEntity, type, new Object[0]);
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                this.logger.error("{}\u8bf7\u6c42\u51fa\u9519,\u54cd\u5e94\u7801:{}", (Object)url, (Object)responseEntity.getStatusCode());
                throw new ServiceFailException(StrUtil.format((CharSequence)"{}\u8bf7\u6c42\u51fa\u9519,\u54cd\u5e94\u7801:{}", (Object[])new Object[]{url, responseEntity.getStatusCode()}));
            }
            return (T)responseEntity.getBody();
        }
        catch (Exception e) {
            throw new ServiceFailException("\u7f51\u7edc\u8bf7\u6c42\u9519\u8bef");
        }
    }

    public <T> T doGet(String url, MultiValueMap params, MultiValueMap headers, Class<T> responseType, ParameterizedTypeReference type) {
        String urlParam = this.createUrlParamsByMap((MultiValueMap<String, Object>)params);
        if (StringUtils.isNotEmpty((CharSequence)urlParam)) {
            url = url + "?" + urlParam;
        }
        HttpEntity requestEntity = new HttpEntity(null, headers);
        return this.doRequest(url, HttpMethod.GET, requestEntity, responseType, type);
    }

    public <T> T doGet(String url, MultiValueMap params, MultiValueMap headers, Class<T> responseType) {
        return this.doGet(url, params, headers, responseType, null);
    }

    public <T> T doGet(String url, MultiValueMap params, Class<T> responseType) {
        return this.doGet(url, params, null, responseType);
    }

    public String doGet(String url, MultiValueMap params) {
        return this.doGet(url, params, String.class);
    }

    public String doGet(String url) {
        return this.doGet(url, null);
    }

    public <T> T doPost(String url, MultiValueMap params, MultiValueMap headers, Class<T> responseType, ParameterizedTypeReference type) {
        HttpEntity requestEntity = new HttpEntity((Object)params, headers);
        return this.doRequest(url, HttpMethod.POST, requestEntity, responseType, type);
    }

    public <T> T doPost(String url, MultiValueMap params, MultiValueMap headers, Class<T> responseType) {
        return this.doPost(url, params, headers, responseType, null);
    }

    public <T> T doPost(String url, MultiValueMap params, Class<T> responseType) {
        return this.doPost(url, params, null, responseType);
    }

    public String doPost(String url, MultiValueMap params) {
        return this.doPost(url, params, String.class);
    }

    public String doPost(String url) {
        return this.doPost(url, null);
    }

    private String createUrlParamsByMap(MultiValueMap<String, Object> map) {
        try {
            if (map == null) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                List list = (List)entry.getValue();
                for (Object val : list) {
                    sb.append((String)entry.getKey() + "=" + URLEncoder.encode(val.toString(), "UTF-8"));
                    sb.append("&");
                }
            }
            String s = sb.toString();
            if (s.endsWith("&")) {
                s = StringUtils.substringBeforeLast((String)s, (String)"&");
            }
            return s;
        }
        catch (Exception e) {
            this.logger.error("map\u8f6curl\u53c2\u6570\u5f02\u5e38{}", (Throwable)e);
            return "";
        }
    }
}

