/*
 * Decompiled with CFR 0.152.
 */
package cn.hollycloud.iplatform.common.utils;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ZipUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class SwaggerUtils {
    public static File generate(String packageName, String outputFolder) throws Exception {
        List<String> classNames;
        String folderStr = "/brotherStrongsShowTime";
        File folder = new File(outputFolder + folderStr);
        FileUtil.del((File)folder);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if ((classNames = SwaggerUtils.getClassName(packageName, false)) != null) {
            for (String className : classNames) {
                Field[] fields;
                Class<?> clazz = Class.forName(className);
                ApiModel apiModel = clazz.getAnnotation(ApiModel.class);
                String fileName = clazz.getSimpleName();
                if (apiModel != null) {
                    fileName = apiModel.value();
                }
                File file = new File(folder, fileName + ".vue");
                FileWriter fw = new FileWriter(file);
                for (Field field : fields = clazz.getDeclaredFields()) {
                    String tag;
                    ApiModelProperty apiModelProperty = field.getAnnotation(ApiModelProperty.class);
                    if (apiModelProperty != null) {
                        tag = "<" + SwaggerUtils.getUiTag(field.getType()) + " v-model=\"data." + field.getName() + "\" label=\"" + apiModelProperty.value() + "\" " + (apiModelProperty.required() ? "required" : "") + SwaggerUtils.getUiType(field.getType()) + "/>\n";
                        fw.write(tag);
                        continue;
                    }
                    tag = "<" + SwaggerUtils.getUiTag(field.getType()) + " v-model=\"data." + field.getName() + "\" label=\"\" " + SwaggerUtils.getUiType(field.getType()) + "/>\n";
                    fw.write(tag);
                }
                fw.close();
            }
        }
        File file = ZipUtil.zip((File)folder);
        FileUtil.del((File)folder);
        return file;
    }

    private static String getUiTag(Class clazz) {
        if (clazz.getSimpleName().equals("LocalDateTime") || clazz.getSimpleName().equals("LocalDate")) {
            return "ui-date";
        }
        if (clazz.getSimpleName().equals("Integer") || clazz.getSimpleName().equals("Long")) {
            return "ui-number";
        }
        return "ui-text";
    }

    private static String getUiType(Class clazz) {
        if (clazz.getSimpleName().equals("LocalDateTime")) {
            return " type=\"datetime\"";
        }
        if (clazz.getSimpleName().equals("LocalDate")) {
            return " type=\"date\"";
        }
        return "";
    }

    public static List<String> getClassName(String packageName) {
        return SwaggerUtils.getClassName(packageName, true);
    }

    public static List<String> getClassName(String packageName, boolean childPackage) {
        String packagePath;
        List<String> fileNames = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(packagePath = packageName.replace(".", "/"));
        if (url != null) {
            String type = url.getProtocol();
            if (type.equals("file")) {
                fileNames = SwaggerUtils.getClassNameByFile(url.getPath(), null, childPackage);
            } else if (type.equals("jar")) {
                fileNames = SwaggerUtils.getClassNameByJar(url.getPath(), childPackage);
            }
        } else {
            fileNames = SwaggerUtils.getClassNameByJars(((URLClassLoader)loader).getURLs(), packagePath, childPackage);
        }
        return fileNames;
    }

    private static List<String> getClassNameByFile(String filePath, List<String> className, boolean childPackage) {
        File[] childFiles;
        ArrayList<String> myClassName = new ArrayList<String>();
        File file = new File(filePath);
        for (File childFile : childFiles = file.listFiles()) {
            if (childFile.isDirectory()) {
                if (!childPackage) continue;
                myClassName.addAll(SwaggerUtils.getClassNameByFile(childFile.getPath(), myClassName, childPackage));
                continue;
            }
            String childFilePath = childFile.getPath();
            if (!childFilePath.endsWith(".class")) continue;
            childFilePath = childFilePath.substring(childFilePath.indexOf("\\classes") + 9, childFilePath.lastIndexOf("."));
            childFilePath = childFilePath.replace("\\", ".");
            myClassName.add(childFilePath);
        }
        return myClassName;
    }

    private static List<String> getClassNameByJar(String jarPath, boolean childPackage) {
        ArrayList<String> myClassName = new ArrayList<String>();
        String[] jarInfo = jarPath.split("!");
        String jarFilePath = jarInfo[0].substring(jarInfo[0].indexOf("/"));
        String packagePath = jarInfo[1].substring(1);
        try {
            JarFile jarFile = new JarFile(jarFilePath);
            Enumeration<JarEntry> entrys = jarFile.entries();
            while (entrys.hasMoreElements()) {
                JarEntry jarEntry = entrys.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.endsWith(".class")) continue;
                if (childPackage) {
                    if (!entryName.startsWith(packagePath)) continue;
                    entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                    myClassName.add(entryName);
                    continue;
                }
                int index = entryName.lastIndexOf("/");
                String myPackagePath = index != -1 ? entryName.substring(0, index) : entryName;
                if (!myPackagePath.equals(packagePath)) continue;
                entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                myClassName.add(entryName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return myClassName;
    }

    private static List<String> getClassNameByJars(URL[] urls, String packagePath, boolean childPackage) {
        ArrayList<String> myClassName = new ArrayList<String>();
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                URL url = urls[i];
                String urlPath = url.getPath();
                if (urlPath.endsWith("classes/")) continue;
                String jarPath = urlPath + "!/" + packagePath;
                myClassName.addAll(SwaggerUtils.getClassNameByJar(jarPath, childPackage));
            }
        }
        return myClassName;
    }
}

