/*
 * Decompiled with CFR 0.152.
 */
package cn.hollycloud.iplatform.common.utils;

import cn.hollycloud.iplatform.common.bean.TreeBean;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TreeUtils {
    public static List<TreeBean> parseTree(JSONArray flatArray, String idName, String parentIdName, String displayName) {
        ArrayList<TreeBean> tree = new ArrayList<TreeBean>();
        List<TreeBean> treeBeans = TreeUtils.handleTree(flatArray, idName, parentIdName, displayName);
        for (TreeBean treeBean : treeBeans) {
            if (treeBean.getParentId() != null) continue;
            tree.add(treeBean);
        }
        return tree;
    }

    private static List<TreeBean> handleTree(JSONArray flatArray, String idName, String parentIdName, String displayName) {
        Object object;
        int i;
        ArrayList<TreeBean> tree = new ArrayList<TreeBean>();
        HashMap<Object, TreeBean> map = new HashMap<Object, TreeBean>();
        for (i = 0; i < flatArray.size(); ++i) {
            object = flatArray.getJSONObject(i);
            TreeBean treeBean = new TreeBean();
            Object id = object.get((Object)idName);
            if (id == null) continue;
            treeBean.setId(id);
            Object name = object.get((Object)displayName);
            if (name == null) continue;
            treeBean.setDisplayName(name);
            Object parentId = object.get((Object)parentIdName);
            if (parentId != null) {
                treeBean.setParentId(parentId);
            }
            treeBean.setNativeObject((JSONObject)object);
            treeBean.setDisplayName(name);
            map.put(id, treeBean);
            tree.add(treeBean);
        }
        for (i = 0; i < tree.size(); ++i) {
            TreeBean parentNode;
            object = (TreeBean)tree.get(i);
            Object parentId = ((TreeBean)object).getParentId();
            if (parentId == null || (parentNode = (TreeBean)map.get(parentId)) == null) continue;
            List<TreeBean> children = parentNode.getChildren();
            children.add((TreeBean)object);
            parentNode.setIsLeaf(false);
        }
        return tree;
    }

    public static List<TreeBean> mountTree(JSONArray flatArray, String idName, String parentIdName, String displayName, JSONArray childNodes, String childIdName, String childParentIdName, String childDisplayName) {
        int i;
        ArrayList<TreeBean> tree = new ArrayList<TreeBean>();
        List<TreeBean> treeBeans = TreeUtils.handleTree(flatArray, idName, parentIdName, displayName);
        HashMap<Object, TreeBean> map = new HashMap<Object, TreeBean>();
        for (i = 0; i < treeBeans.size(); ++i) {
            TreeBean treeBean = treeBeans.get(i);
            treeBean.setIsLeaf(false);
            if (treeBean.getParentId() == null) {
                tree.add(treeBean);
            }
            map.put(treeBean.getId(), treeBean);
        }
        for (i = 0; i < childNodes.size(); ++i) {
            JSONObject childNode = childNodes.getJSONObject(i);
            TreeBean treeBean = new TreeBean();
            Object id = childNode.get((Object)childIdName);
            if (id == null) continue;
            treeBean.setId(id);
            Object name = childNode.get((Object)childDisplayName);
            if (name == null) continue;
            treeBean.setDisplayName(name);
            treeBean.setNativeObject(childNode);
            Object parentId = childNode.get((Object)childParentIdName);
            if (parentId == null) {
                tree.add(treeBean);
                continue;
            }
            treeBean.setParentId(parentId);
            TreeBean parentNode = (TreeBean)map.get(parentId);
            if (parentNode == null) continue;
            List<TreeBean> children = parentNode.getChildren();
            children.add(treeBean);
        }
        return tree;
    }
}

