/*
 * Decompiled with CFR 0.152.
 */
package cn.hollycloud.iplatform.common.utils;

import cn.hollycloud.iplatform.common.annotation.TreeId;
import cn.hollycloud.iplatform.common.annotation.TreeName;
import cn.hollycloud.iplatform.common.annotation.TreeParentId;
import cn.hollycloud.iplatform.common.bean.TreeBean;
import cn.hollycloud.iplatform.common.exception.ServiceFailException;
import cn.hollycloud.iplatform.common.utils.JsonUtils;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TreeUtils {
    public static List<TreeBean> parseTree(JSONArray flatArray, String idName, String parentIdName, String displayName) {
        ArrayList<TreeBean> tree = new ArrayList<TreeBean>();
        List<TreeBean> treeBeans = TreeUtils.handleTree(flatArray, idName, parentIdName, displayName);
        for (TreeBean treeBean : treeBeans) {
            if (treeBean.getParentId() != null && !treeBean.getParentId().equals(0)) continue;
            tree.add(treeBean);
        }
        return tree;
    }

    public static List<TreeBean> parseTree(List list, Class clazz) {
        Field[] fields = ReflectUtil.getFields((Class)clazz);
        String idName = null;
        String parentIdName = null;
        String displayName = null;
        for (Field field : fields) {
            if (field.getAnnotation(TreeId.class) != null) {
                idName = field.getName();
                continue;
            }
            if (field.getAnnotation(TreeName.class) != null) {
                displayName = field.getName();
                continue;
            }
            if (field.getAnnotation(TreeParentId.class) == null) continue;
            parentIdName = field.getName();
        }
        if (StringUtils.isEmpty(idName)) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230TreeId\u6ce8\u89e3");
        }
        if (StringUtils.isEmpty(parentIdName)) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230TreeParentId\u6ce8\u89e3");
        }
        if (StringUtils.isEmpty(displayName)) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230TreeName\u6ce8\u89e3");
        }
        JSONArray jsonArray = JSONArray.parseArray((String)JsonUtils.serialize(list));
        return TreeUtils.parseTree(jsonArray, idName, parentIdName, displayName);
    }

    private static List<TreeBean> handleTree(JSONArray flatArray, String idName, String parentIdName, String displayName) {
        Object object;
        int i;
        ArrayList<TreeBean> tree = new ArrayList<TreeBean>();
        HashMap<Object, TreeBean> map = new HashMap<Object, TreeBean>();
        for (i = 0; i < flatArray.size(); ++i) {
            object = flatArray.getJSONObject(i);
            TreeBean treeBean = new TreeBean();
            Object id = object.get((Object)idName);
            if (id == null) continue;
            treeBean.setId(id);
            Object name = object.get((Object)displayName);
            if (name == null) continue;
            treeBean.setDisplayName(name);
            Object parentId = object.get((Object)parentIdName);
            if (parentId != null) {
                treeBean.setParentId(parentId);
            }
            treeBean.setNativeObject((JSONObject)object);
            treeBean.setDisplayName(name);
            map.put(id, treeBean);
            tree.add(treeBean);
        }
        for (i = 0; i < tree.size(); ++i) {
            TreeBean parentNode;
            object = (TreeBean)tree.get(i);
            Object parentId = ((TreeBean)object).getParentId();
            if (parentId == null || (parentNode = (TreeBean)map.get(parentId)) == null) continue;
            List<TreeBean> children = parentNode.getChildren();
            children.add((TreeBean)object);
            parentNode.setIsLeaf(false);
        }
        return tree;
    }

    public static List<TreeBean> mountTree(JSONArray flatArray, String idName, String parentIdName, String displayName, JSONArray childNodes, String childIdName, String childParentIdName, String childDisplayName) {
        int i;
        ArrayList<TreeBean> tree = new ArrayList<TreeBean>();
        List<TreeBean> treeBeans = TreeUtils.handleTree(flatArray, idName, parentIdName, displayName);
        HashMap<Object, TreeBean> map = new HashMap<Object, TreeBean>();
        for (i = 0; i < treeBeans.size(); ++i) {
            TreeBean treeBean = treeBeans.get(i);
            treeBean.setIsLeaf(false);
            if (treeBean.getParentId() == null || treeBean.getParentId().equals(0)) {
                tree.add(treeBean);
            }
            map.put(treeBean.getId(), treeBean);
        }
        for (i = 0; i < childNodes.size(); ++i) {
            JSONObject childNode = childNodes.getJSONObject(i);
            TreeBean treeBean = new TreeBean();
            Object id = childNode.get((Object)childIdName);
            if (id == null) continue;
            treeBean.setId(id);
            Object name = childNode.get((Object)childDisplayName);
            if (name == null) continue;
            treeBean.setDisplayName(name);
            treeBean.setNativeObject(childNode);
            Object parentId = childNode.get((Object)childParentIdName);
            if (parentId == null) {
                tree.add(treeBean);
                continue;
            }
            treeBean.setParentId(parentId);
            TreeBean parentNode = (TreeBean)map.get(parentId);
            if (parentNode == null) continue;
            List<TreeBean> children = parentNode.getChildren();
            children.add(treeBean);
        }
        return tree;
    }

    public static List<TreeBean> mountTree(List parentList, Class parentClass, List childList, Class childClass) {
        Field[] fields = ReflectUtil.getFields((Class)parentClass);
        String idName = null;
        String parentIdName = null;
        String displayName = null;
        for (Field field : fields) {
            if (field.getAnnotation(TreeId.class) != null) {
                idName = field.getName();
                continue;
            }
            if (field.getAnnotation(TreeName.class) != null) {
                displayName = field.getName();
                continue;
            }
            if (field.getAnnotation(TreeParentId.class) == null) continue;
            parentIdName = field.getName();
        }
        if (StringUtils.isEmpty(idName)) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230TreeId\u6ce8\u89e3");
        }
        if (StringUtils.isEmpty(parentIdName)) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230TreeParentId\u6ce8\u89e3");
        }
        if (StringUtils.isEmpty(displayName)) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230TreeName\u6ce8\u89e3");
        }
        fields = ReflectUtil.getFields((Class)childClass);
        String childIdName = null;
        String childParentIdName = null;
        String childDisplayName = null;
        for (Field field : fields) {
            if (field.getAnnotation(TreeId.class) != null) {
                childIdName = field.getName();
                continue;
            }
            if (field.getAnnotation(TreeName.class) != null) {
                childDisplayName = field.getName();
                continue;
            }
            if (field.getAnnotation(TreeParentId.class) == null) continue;
            childParentIdName = field.getName();
        }
        if (StringUtils.isEmpty(childIdName)) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230\u5b50\u8282\u70b9TreeId\u6ce8\u89e3");
        }
        if (StringUtils.isEmpty(childParentIdName)) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230\u5b50\u8282\u70b9TreeParentId\u6ce8\u89e3");
        }
        if (StringUtils.isEmpty(childDisplayName)) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230\u5b50\u8282\u70b9TreeName\u6ce8\u89e3");
        }
        JSONArray jSONArray = JSONArray.parseArray((String)JsonUtils.serialize(parentList));
        JSONArray childJsonArray = JSONArray.parseArray((String)JsonUtils.serialize(childList));
        return TreeUtils.mountTree(jSONArray, idName, parentIdName, displayName, childJsonArray, childIdName, childParentIdName, childDisplayName);
    }

    public static List parseStandardTree(List list, Class clazz) {
        Field[] fields = ReflectUtil.getFields((Class)clazz);
        String idName = null;
        String parentIdName = null;
        for (Field field : fields) {
            if (field.getAnnotation(TreeId.class) != null) {
                idName = field.getName();
                continue;
            }
            if (field.getAnnotation(TreeParentId.class) == null) continue;
            parentIdName = field.getName();
        }
        if (StringUtils.isEmpty(idName)) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230TreeId\u6ce8\u89e3");
        }
        if (StringUtils.isEmpty(parentIdName)) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230TreeParentId\u6ce8\u89e3");
        }
        JSONArray jsonArray = JSONArray.parseArray((String)JsonUtils.serialize(list));
        return TreeUtils.parseStandardTree(jsonArray, idName, parentIdName);
    }

    public static List parseStandardTree(JSONArray flatArray, String idName, String parentIdName) {
        ArrayList<JSONObject> tree = new ArrayList<JSONObject>();
        List<JSONObject> treeBeans = TreeUtils.handleStandardTree(flatArray, idName, parentIdName);
        for (JSONObject treeBean : treeBeans) {
            if (treeBean.get((Object)parentIdName) != null) continue;
            tree.add(treeBean);
        }
        return tree;
    }

    private static List<JSONObject> handleStandardTree(JSONArray flatArray, String idName, String parentIdName) {
        JSONObject object;
        int i;
        ArrayList<JSONObject> tree = new ArrayList<JSONObject>();
        HashMap<Object, JSONObject> map = new HashMap<Object, JSONObject>();
        for (i = 0; i < flatArray.size(); ++i) {
            object = flatArray.getJSONObject(i);
            object.put("isLeaf", (Object)true);
            Object id = object.get((Object)idName);
            if (id == null) continue;
            map.put(id, object);
            tree.add(object);
        }
        for (i = 0; i < tree.size(); ++i) {
            JSONObject parentNode;
            object = (JSONObject)tree.get(i);
            Object parentId = object.get((Object)parentIdName);
            if (parentId == null || (parentNode = (JSONObject)map.get(parentId)) == null) continue;
            JSONArray children = parentNode.getJSONArray("children");
            if (children == null) {
                children = new JSONArray();
                parentNode.put("children", (Object)children);
            }
            children.add((Object)object);
            parentNode.put("isLeaf", (Object)false);
        }
        return tree;
    }
}

