/*
 * Decompiled with CFR 0.152.
 */
package cn.hollycloud.iplatform.common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final ObjectMapper typeMapper = new ObjectMapper();
    private static final Logger logger;

    public static void customizeConfig(ObjectMapper mapper) {
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        mapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, false);
        mapper.configure(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
        mapper.configure(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, false);
        mapper.configure(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, true);
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, false);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, false);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        javaTimeModule.addDeserializer(Boolean.class, (JsonDeserializer)new BooleanDeserializer());
        mapper.registerModule((Module)javaTimeModule).registerModule((Module)new ParameterNamesModule());
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    }

    public static void deseriaNullToEmpty(ObjectMapper objectMapper) {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(String.class, (JsonDeserializer)new CustomStringDeserializer());
        objectMapper.registerModule((Module)module);
    }

    public static String serialize(Object obj) {
        return JsonUtils.serialize(obj, mapper);
    }

    public static String serialize(Object obj, ObjectMapper mapper) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass() == String.class) {
            return (String)obj;
        }
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            logger.error("json\u5e8f\u5217\u5316\u51fa\u9519\uff1a" + obj, (Throwable)e);
            return null;
        }
    }

    public static <T> T parse(String json, Class<T> tClass, ObjectMapper mapper) {
        try {
            return (T)mapper.readValue(json, tClass);
        }
        catch (IOException e) {
            logger.error("json\u89e3\u6790\u51fa\u9519\uff1a" + json, (Throwable)e);
            return null;
        }
    }

    public static <T> T parse(String json, Class<T> tClass) {
        return JsonUtils.parse(json, tClass, mapper);
    }

    public static <E> List<E> parseList(String json, Class<E> eClass) {
        try {
            return (List)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, eClass));
        }
        catch (IOException e) {
            logger.error("json\u89e3\u6790\u51fa\u9519\uff1a" + json, (Throwable)e);
            return null;
        }
    }

    public static <K, V> Map<K, V> parseMap(String json, Class<K> kClass, Class<V> vClass) {
        try {
            return (Map)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructMapType(Map.class, kClass, vClass));
        }
        catch (IOException e) {
            logger.error("json\u89e3\u6790\u51fa\u9519\uff1a" + json, (Throwable)e);
            return null;
        }
    }

    public static <T> T nativeRead(String json, TypeReference<T> type) {
        try {
            return (T)mapper.readValue(json, type);
        }
        catch (IOException e) {
            logger.error("json\u89e3\u6790\u51fa\u9519\uff1a" + json, (Throwable)e);
            return null;
        }
    }

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static ObjectMapper getTypeMapper() {
        return typeMapper;
    }

    static {
        JsonUtils.customizeConfig(mapper);
        JsonUtils.customizeConfig(typeMapper);
        typeMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        typeMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        logger = LoggerFactory.getLogger(JsonUtils.class);
    }

    static class BooleanDeserializer
    extends JsonDeserializer<Boolean> {
        BooleanDeserializer() {
        }

        public Boolean deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonToken currentToken = jp.getCurrentToken();
            if (currentToken.equals((Object)JsonToken.VALUE_STRING)) {
                String text = jp.getText();
                if (StringUtils.isEmpty((CharSequence)text)) {
                    return null;
                }
                if ("Y".equalsIgnoreCase(text)) {
                    return Boolean.TRUE;
                }
                if ("N".equalsIgnoreCase(text)) {
                    return Boolean.FALSE;
                }
                if ("0".equals(text)) {
                    return Boolean.FALSE;
                }
                if ("1".equals(text)) {
                    return Boolean.TRUE;
                }
                throw ctxt.weirdStringException(text, Boolean.class, "boolean\u503c\u4e0d\u6b63\u786e");
            }
            if (currentToken.equals((Object)JsonToken.VALUE_NULL)) {
                return null;
            }
            if (currentToken.equals((Object)JsonToken.VALUE_TRUE)) {
                return Boolean.TRUE;
            }
            if (currentToken.equals((Object)JsonToken.VALUE_FALSE)) {
                return Boolean.FALSE;
            }
            if (currentToken.equals((Object)JsonToken.VALUE_NUMBER_INT)) {
                int val = jp.getIntValue();
                if (val == 0) {
                    return Boolean.FALSE;
                }
                if (val == 1) {
                    return Boolean.TRUE;
                }
                throw ctxt.weirdStringException(val + "", Boolean.class, "boolean\u503c\u4e0d\u6b63\u786e");
            }
            throw ctxt.mappingException("Can't parse boolean value: " + jp.getText());
        }
    }

    static class CustomStringDeserializer
    extends StringDeserializer {
        CustomStringDeserializer() {
        }

        public String getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            return "";
        }
    }
}

