/*
 * Decompiled with CFR 0.152.
 */
package cn.hollycloud.iplatform.common.utils;

import cn.hollycloud.iplatform.common.utils.JsonUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjTransformUtils {
    private static final Logger logger = LoggerFactory.getLogger(ObjTransformUtils.class);

    public static <T> T fatherToChild(Object father, Class<T> childClass) {
        try {
            if (childClass.getSuperclass() != father.getClass()) {
                return null;
            }
            T child = childClass.newInstance();
            Class<?> fatherClass = father.getClass();
            Field[] ff = fatherClass.getDeclaredFields();
            for (int i = 0; i < ff.length; ++i) {
                Field f = ff[i];
                if (Modifier.isStatic(f.getModifiers()) || Modifier.isFinal(f.getModifiers()) || f.isEnumConstant()) continue;
                f.setAccessible(true);
                Class<?> type = f.getType();
                Method m = fatherClass.getMethod("get" + ObjTransformUtils.upperHeadChar(f.getName()), new Class[0]);
                if (m == null) continue;
                Object obj = m.invoke(father, new Object[0]);
                f.set(child, obj);
            }
            return child;
        }
        catch (Exception e) {
            logger.error("fatherToChild\u8f6c\u6362\u5f02\u5e38{}", (Throwable)e);
            return null;
        }
    }

    public static <T> T toOtherObj(Object obj, Class<T> otherClass) {
        String json = JsonUtils.serialize(obj);
        return JsonUtils.parse(json, otherClass);
    }

    public static <T> List<T> toOtherList(List list, Class<T> otherClass) {
        ArrayList<T> otherList = new ArrayList<T>();
        for (Object obj : list) {
            otherList.add(ObjTransformUtils.toOtherObj(obj, otherClass));
        }
        return otherList;
    }

    public static String upperHeadChar(String in) {
        String head = in.substring(0, 1);
        String out = head.toUpperCase() + in.substring(1, in.length());
        return out;
    }
}

